/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.operations.SaveQModelUIOperation;
import eu.qimpress.ide.backbone.core.ui.decorators.QModelNeedsSaveMarkerConst;

/**
 * @author Michal Malohlava
 *
 */
public class SaveModelAction implements IObjectActionDelegate {
	
	private static final Logger logger = Logger.getLogger(SaveModelAction.class);
	
	private Shell shell;
	
	private IQModel selectedQModel;	

	@Override
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		this.shell = targetPart.getSite().getShell();
	}

	@Override
	public void run(IAction action) {
		if (selectedQModel == null) {
			return;
		}
		try {
			new SaveQModelUIOperation(selectedQModel).run(new NullProgressMonitor());
		} catch (Exception e) {			
			logger.error("Cannot save selected model: " + selectedQModel, e);
			MessageDialog.openError(getShell(), "Model save failed", "Cannot save model " + selectedQModel);
		}
	}

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		this.selectedQModel = null;
		
		action.setEnabled(false);		
		
		if (selection instanceof IStructuredSelection
				&& !((IStructuredSelection) selection).isEmpty()) {
			Object element = ((IStructuredSelection) selection).getFirstElement();
			if (element instanceof IQModel) {
				this.selectedQModel = (IQModel) element;
			} else if (element instanceof IAdaptable) {
				this.selectedQModel = (IQModel) ((IAdaptable) element).getAdapter(IQModel.class);				
			} else if (element instanceof EObject) {
				this.selectedQModel = (IQModel) Platform.getAdapterManager().getAdapter(element, IQModel.class);
			}
		}
		
		if (this.selectedQModel != null) {
			IResource modelResource = this.selectedQModel.getCorrespondingResource();
			
			try { 
				if (modelResource.findMarkers(QModelNeedsSaveMarkerConst.MARKER_ID, true, IResource.DEPTH_ZERO).length > 0) {
					action.setEnabled(true);					
				}
			} catch (CoreException e) {
				// do nothing
			}			
		}		
	}
	
	protected Shell getShell() {
		return this.shell;
	}
}
