/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ISetSelectionTarget;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.IQElement.ElementType;

/**
 * @author Michal Malohlava
 *
 */
public abstract class QElementSelectionDispatchAction extends Action implements ISelectionChangedListener {
	
	private final static Logger logger = Logger.getLogger(QElementSelectionDispatchAction.class);
	
	protected static final IQElement[] EMPTY_SELECTION = new IQElement[] {};
	
	private IQElement[] selectedElements;
	private IStructuredSelection selection;
	
	private IWorkbenchSite workbenchSite;
	private ISetSelectionTarget selectionTarget;
	
	public QElementSelectionDispatchAction() {
		this(null, null);
	}
	
	public QElementSelectionDispatchAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget) {
		this.workbenchSite = site;
		this.selectionTarget = selectionTarget;
	}
	
	public QElementSelectionDispatchAction(IWorkbenchSite site) {
		this(site, null);		
	}	
	
	@Override
	public void run() {
		if (this.selectedElements.length > 0) {
			ElementType commonElementType = this.selectedElements[0].getElementType();
			
			switch (commonElementType) {
			case Q_ALTERNATIVE:
				runInternal(Arrays.copyOf(this.selectedElements, this.selectedElements.length, IQAlternative[].class));
				break;
			case Q_REPOSITORY:
				runInternal(Arrays.copyOf(this.selectedElements, this.selectedElements.length, IQRepository[].class));			
				break;
			case Q_MODEL:
				runInternal(Arrays.copyOf(this.selectedElements, this.selectedElements.length, IQModel[].class));
			default:
				break;
			}				
		}
	}

	protected void runInternal(IQRepository[] repository) {};
	
	protected void runInternal(IQAlternative[] alternative) {};
	
	protected void runInternal(IQModel[] model) {};
	
	protected Shell getShell() {
		return workbenchSite != null ? workbenchSite.getShell() : Display.getDefault().getActiveShell();
	}

	@Override
	public void selectionChanged(SelectionChangedEvent event) {
		ISelection selection = event.getSelection();
			
		this.selectedElements = null;
		if (selection instanceof IStructuredSelection) {
			this.selection = (IStructuredSelection) selection;
			
			if (((IStructuredSelection) selection).size() > 0
					&& selectedSameTypeElements((IStructuredSelection) selection)) {
				
				 this.selectedElements = getElementList((IStructuredSelection) selection);
			} else {
				this.selectedElements = EMPTY_SELECTION;
			}
		} 
		
		postSelectionChanged(this.selectedElements);
	}
	
	@SuppressWarnings("unchecked")
	private boolean selectedSameTypeElements(IStructuredSelection selection) {
	   IQElement qElement = getQElement(selection.getFirstElement());
       if (qElement == null) {
           return false;
       }
	   
	   ElementType commonType = qElement.getElementType();
		
		for (Iterator it = selection.iterator(); it.hasNext(); ) {
			IQElement qe = getQElement(it.next());
			if (qe.getElementType() != commonType) {
				return false;
			}		
		}
		
		return true;
	}
	
	
     private IQElement getQElement(Object o) {
         if (o instanceof IQElement) {
             return (IQElement) o;
         } else if (o instanceof IAdaptable) {
             return ((IQElement) ((IAdaptable) o).getAdapter(IQElement.class));
         }
 
         return null;
     }
 
     private IQElement[] getElementList(IStructuredSelection selection) {
         List<Object> elementList = ((IStructuredSelection) selection).toList();
         IQElement[] result = new IQElement[elementList.size()];
         int i = 0;
 
         for(Object o : elementList) {
             IQElement qe = getQElement(o);
             if (qe == null) {
                 return EMPTY_SELECTION;
             }
             result[i++] = qe;
         }
 
         return result;
     }
	
	protected void postSelectionChanged(IQElement[] element) {}

	protected IQElement[] getSelectedElement() {
		return selectedElements;
	}
	
	protected IWorkbenchSite getSite() {
		return this.workbenchSite;
	}
	
	protected void reportError(String msg, Throwable t) {
		logger.error("Error occured in action handler.", t);
		MessageDialog.openError(getShell(), "Error occured", msg);
	}
	
	public IStructuredSelection getSelection() {
		return selection;
	}
	
	protected void unselect() {
		if (selectionTarget != null) {
			this.selectionTarget.selectReveal(StructuredSelection.EMPTY);
		}
	}

}
