package eu.qimpress.ide.backbone.core.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

import eu.qimpress.ide.backbone.core.ui.QImpressUICore;
import eu.qimpress.ide.backbone.core.ui.perspectives.QIPerspective;

public class OpenQImpressPerspectiveAction implements org.eclipse.ui.IActionDelegate {

	@Override
	public void run(IAction action) {
		final IWorkbench workBench = QImpressUICore.getDefault().getWorkbench();
		IWorkbenchWindow window = workBench.getActiveWorkbenchWindow();
		//IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked(event);
		try {
		workBench.showPerspective(QIPerspective.PERSPECTIVE_ID, window, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getInput());
		} catch (WorkbenchException e) {
			   MessageDialog.openError(window.getShell(),
			       "Problem Opening Perspective",
			       e.getMessage());
		}
		workBench.getIntroManager().closeIntro(workBench.getIntroManager().getIntro());
	}

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		// TODO Auto-generated method stub
		
	}
	
}
