/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.navigator.ICommonActionConstants;
import org.eclipse.ui.navigator.ICommonMenuConstants;
import org.eclipse.ui.part.ISetSelectionTarget;

/**
 * Action group for models.
 * 
 * @author Michal Malohlava
 *
 */
public class ModelsActionGroup extends ActionGroup {
	
	public static final String MODELS_MENU_ID = "eu.qimpress.ide.backbone.core.ui.models.menu";
	
	private ModelDefaultOpenAction modelDefaultOpenAction;
	private DeleteModelAction deleteModelAction;
	
	private ISelectionProvider selectionProvider;
	private IWorkbenchSite site;
	
	public ModelsActionGroup(IViewPart viewPart) {
		this(viewPart, null);
	}
	
	public ModelsActionGroup(IViewPart viewPart, ISelectionProvider selectionProvider) {
		this.site = viewPart.getSite();
		this.selectionProvider = selectionProvider;
		
		ISetSelectionTarget selectionTarget = null; 
		if (viewPart instanceof ISetSelectionTarget) {
			selectionTarget = (ISetSelectionTarget) viewPart;
		} else {
			selectionTarget = (ISetSelectionTarget) viewPart.getAdapter(ISetSelectionTarget.class);
		}	
		
		createSiteActions(viewPart.getSite(), selectionProvider, selectionTarget);
		
	}
	
	private void createSiteActions(IWorkbenchSite site, ISelectionProvider selectionProvider, ISetSelectionTarget selectionTarget) {
		this.deleteModelAction = new DeleteModelAction(site, selectionTarget);
		this.modelDefaultOpenAction = new ModelDefaultOpenAction(site);
		
		// register selection providers
		selectionProvider.addSelectionChangedListener(this.deleteModelAction);
		selectionProvider.addSelectionChangedListener(this.modelDefaultOpenAction);
		
		// fire selection event explicitly to select an element 
		this.deleteModelAction.selectionChanged(new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection()));
		this.modelDefaultOpenAction.selectionChanged(new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection()));
	}
	
	@Override
	public void fillActionBars(IActionBars actionBars) {
		shareGlobalActions(actionBars);
	}
	
	@Override
	public void fillContextMenu(IMenuManager menu) {		
		fillViewSubMenu(menu);		
	}
	
	private void fillViewSubMenu(IMenuManager menu) {
		addToGroup(menu, ICommonMenuConstants.GROUP_EDIT, this.deleteModelAction);
		addToGroup(menu, ICommonMenuConstants.GROUP_OPEN_WITH, this.modelDefaultOpenAction);		
	}
	
	private void addToGroup(IMenuManager menu, String groupName, IAction action) {
		if (action.isEnabled()) {
			menu.appendToGroup(groupName, action);
		}
	}

	@Override
	public void setContext(ActionContext context) {		
		super.setContext(context);		
	}
	
	@Override
	public void dispose() {		
		this.selectionProvider.removeSelectionChangedListener(this.modelDefaultOpenAction);
		this.selectionProvider.removeSelectionChangedListener(this.deleteModelAction);
		
		super.dispose();
	}
	
	protected void shareGlobalActions(IActionBars actionBars) {		
		actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), deleteModelAction);
		
		// also registered as double click for each IQModel entity
		actionBars.setGlobalActionHandler(ICommonActionConstants.OPEN, modelDefaultOpenAction);
		
	}	
}
