/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.ISetSelectionTarget;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.model.IQElement.ElementType;
import eu.qimpress.ide.backbone.core.ui.internal.QImpressUICorePluginImages;

/**
 * Make current alternative default.
 * 
 * @author Michal Malohlava
 *
 */
public class MakeAlternativeDefaultAction extends QElementSelectionDispatchAction {

	public MakeAlternativeDefaultAction(IWorkbenchSite site) {
		this(site, null);
	}
	
	public MakeAlternativeDefaultAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget) {
		super(site, selectionTarget);
		setText("Make alternative default");
		setDescription("Make selected alternative default");
		setImageDescriptor(QImpressUICorePluginImages.DESC_DEFAULT_ALTERNATIVE);
	}

	@Override
	protected void runInternal(IQAlternative[] alternatives) {
		if (alternatives.length != 1)
			return;
		
		final IQAlternative alternative = alternatives[0];
		
		if (!alternative.getInfo().isDefault()) {
			final IQRepository repo = alternative.getRepository();
			
			try {
				WorkspaceModifyOperation operation = new WorkspaceModifyOperation() {
					@Override
					protected void execute(IProgressMonitor monitor)
							throws CoreException, InvocationTargetException,
							InterruptedException {
						
						try {
							repo.setDefaultAlternative(alternative);
						} catch (RepositoryException e) {
							throw new InvocationTargetException(e);
						}
					}
				};
				
				operation.run(null);
				
				// !!! CPU intensive if there are many alternatives
				QImpressApplicationModelManager.getManager().getQAppModel().fireRefresh();
			} catch (Exception e) {
				reportError("Cannot make given alternative default!", e);
			}
		}
	}
	
	@Override
	protected void postSelectionChanged(IQElement[] elements) {
		if (elements.length == 1 && elements[0].getElementType() == ElementType.Q_ALTERNATIVE) {
			setEnabled(true);			
		} else {
			setEnabled(false);
		}
	}

}
