/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.navigator.ICommonMenuConstants;
import org.eclipse.ui.part.ISetSelectionTarget;

/**
 * @author Michal Malohlava
 *
 */
public class AlternativesActionGroup extends ActionGroup {
	
	public static final String ALTERNATIVES_MENU_ID = "eu.qimpress.ide.backbone.core.ui.alternatives.menu";
	
	private OpenNewAlternativeWizardAction createAlternativeAction;
	private MakeAlternativeDefaultAction makeAlternativeDefaultAction;
	private DeleteAlternativeAction deleteAlternativeAction;
	private CompleteDeleteAlternativeAction completeDeleteAlternativeAction;
	
	private ISelectionProvider selectionProvider;
	private IWorkbenchSite site;
	
	public AlternativesActionGroup(IViewPart viewPart) {
		this(viewPart, null);
	}
	
	public AlternativesActionGroup(IViewPart viewPart, ISelectionProvider selectionProvider) {
		this.site = viewPart.getSite();
		this.selectionProvider = selectionProvider;
		
		ISetSelectionTarget selectionTarget = null; 
		if (viewPart instanceof ISetSelectionTarget) {
			selectionTarget = (ISetSelectionTarget) viewPart;
		} else {
			selectionTarget = (ISetSelectionTarget) viewPart.getAdapter(ISetSelectionTarget.class);
		}	
		
		createSiteActions(viewPart.getSite(), selectionProvider, selectionTarget);
		
	}
	
	private void createSiteActions(IWorkbenchSite site, ISelectionProvider selectionProvider, ISetSelectionTarget selectionTarget) {
		this.createAlternativeAction = new OpenNewAlternativeWizardAction(site, selectionTarget);
		this.makeAlternativeDefaultAction = new MakeAlternativeDefaultAction(site, selectionTarget);
		this.deleteAlternativeAction = new DeleteAlternativeAction(site);
		this.completeDeleteAlternativeAction = new CompleteDeleteAlternativeAction(site);
		
		// register selection providers
		selectionProvider.addSelectionChangedListener(this.createAlternativeAction);
		selectionProvider.addSelectionChangedListener(this.makeAlternativeDefaultAction);
		selectionProvider.addSelectionChangedListener(this.deleteAlternativeAction);
		selectionProvider.addSelectionChangedListener(this.completeDeleteAlternativeAction);
		
		// fire selection event explicitly to select an element 
		this.createAlternativeAction.selectionChanged(new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection()));
		this.makeAlternativeDefaultAction.selectionChanged(new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection()));
		this.deleteAlternativeAction.selectionChanged(new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection()));
		this.completeDeleteAlternativeAction.selectionChanged(new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection()));
	}
	
	@Override
	public void fillActionBars(IActionBars actionBars) {
		shareGlobalActions(actionBars);
	}
	
	@Override
	public void fillContextMenu(IMenuManager menu) {		
		fillViewSubMenu(menu);		
	}
	
	private void fillViewSubMenu(IMenuManager menu) {
		addToGroup(menu, ICommonMenuConstants.GROUP_NEW, this.createAlternativeAction);
		addToGroup(menu, ICommonMenuConstants.GROUP_ADDITIONS, this.makeAlternativeDefaultAction);
		addToGroup(menu, ICommonMenuConstants.GROUP_EDIT, this.deleteAlternativeAction);
		addToGroup(menu, ICommonMenuConstants.GROUP_EDIT, this.completeDeleteAlternativeAction);
	}
	
	private void addToGroup(IMenuManager menu, String groupName, IAction action) {
		if (action.isEnabled()) {
			menu.appendToGroup(groupName, action);
		}
	}

	@Override
	public void setContext(ActionContext context) {		
		super.setContext(context);		
	}
	
	@Override
	public void dispose() {		
		this.selectionProvider.removeSelectionChangedListener(this.completeDeleteAlternativeAction);
		this.selectionProvider.removeSelectionChangedListener(this.deleteAlternativeAction);
		this.selectionProvider.removeSelectionChangedListener(this.makeAlternativeDefaultAction);
		this.selectionProvider.removeSelectionChangedListener(this.createAlternativeAction);
		
		super.dispose();
	}
	
	protected void shareGlobalActions(IActionBars actionBars) {
		actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), deleteAlternativeAction);				
	}	
}
