/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.models.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.navigator.ICommonMenuConstants;

/**
 * Based on generated EMF.Editor code - ActionBarContributor
 * 
 * @author Michal Malohlava
 *
 */
public class SammModelFamilyActionsGroup extends ActionGroup implements ISelectionChangedListener {
	
	// Show properties view action
	protected IAction showPropertiesViewAction =
		new Action("Show properties view") {
			@Override
			public void run() {
				try {
					activePart.getSite().getPage().showView("org.eclipse.ui.views.PropertySheet");
				}
				catch (PartInitException e) {					
					e.printStackTrace();
				}
			}
		};

	
	// global actions		
	protected DeleteAction deleteAction;
	protected UndoAction undoAction;
	protected RedoAction redoAction;
	
	private ISelectionProvider selectionProvider;
	private IWorkbenchPart activePart;
	
	private IMenuManager createChildMenuManager;
	private Collection<IAction> createChildActions;
	
	private IMenuManager createSiblingMenuManager;
	private Collection<IAction> createSiblingActions;
	
	public SammModelFamilyActionsGroup(IViewPart viewPart) {
		this(viewPart, null);
	}

	public SammModelFamilyActionsGroup(IViewPart viewPart, ISelectionProvider selectionProvider) {
		this.activePart = viewPart;
		this.selectionProvider = selectionProvider;		
		this.createChildMenuManager = new MenuManager("Create child");
		this.createSiblingMenuManager = new MenuManager("Create sibling");
		
		this.selectionProvider.addSelectionChangedListener(this);
				
		initActions();
	}
	
	private void initActions() {
		ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
		
		deleteAction = new DeleteAction(true); 
	    deleteAction.setImageDescriptor(sharedImages.getImageDescriptor(ISharedImages.IMG_TOOL_DELETE));	    
	    
	    undoAction = new UndoAction();
	    undoAction.setImageDescriptor(sharedImages.getImageDescriptor(ISharedImages.IMG_TOOL_UNDO));
	    

	    redoAction = new RedoAction();
	    redoAction.setImageDescriptor(sharedImages.getImageDescriptor(ISharedImages.IMG_TOOL_REDO));	    
		
	}
	
	private void initMenus(IMenuManager menu) {
		menu.insertBefore(ICommonMenuConstants.GROUP_ADDITIONS, createChildMenuManager);		
		menu.insertBefore(ICommonMenuConstants.GROUP_ADDITIONS, createSiblingMenuManager);				
	}
	
	@Override
	public void fillActionBars(IActionBars actionBars) {
		super.fillActionBars(actionBars);
		
		shareGlobalActions(actionBars);
	}

	@SuppressWarnings("unchecked")
	@Override
	public void fillContextMenu(IMenuManager menu) {		
		super.fillContextMenu(menu);
	
		ISelection selection = this.getContext().getSelection(); 
		if (selection instanceof IStructuredSelection) {
			List<EObject> eos = new ArrayList<EObject>(5);
			
			Iterator it = ((IStructuredSelection) selection).iterator();
			while (it.hasNext()) {
				Object o = it.next();
				if (!(o instanceof EObject)) {
					return;
				}
				
				eos.add((EObject) o);
			}									
			// fill actions
			if (eos.size() > 0) {
				fillMenus(menu, eos, selection);
			}
		}
	}
	
	private EditingDomain getEditingDomain(EObject eo) {
		return ((IEditingDomainProvider) eo.eResource().getResourceSet()).getEditingDomain();		
	}
	
	protected void fillMenus(IMenuManager menu, List<EObject> selectedEntity, ISelection selection) {
		// add menus into the main menu
		initMenus(menu);

		Collection<?> newChildDescriptors = null;
		Collection<?> newSiblingDescriptors = null;
		EditingDomain domain = null;

//		domain = ((IEditingDomainProvider) Platform.getAdapterManager().getAdapter(selectedEntity, IEditingDomainProvider.class)).getEditingDomain();
		// TODO we get editing domain of a first selected object, which is in fact wrong, because selection can contains objects from different editing domains. 
		domain = getEditingDomain(selectedEntity.get(0));
		
		if (selectedEntity.size() == 1) {
	
			newChildDescriptors = domain.getNewChildDescriptors(selectedEntity.get(0), null);
			newSiblingDescriptors = domain.getNewChildDescriptors(null, selectedEntity.get(0));
	
			// Generate actions for selection
			createChildActions = generateCreateChildActions(newChildDescriptors, selection);
			createSiblingActions = generateCreateSiblingActions(newSiblingDescriptors, selection);
	
			if (createChildMenuManager != null) {
				populateManager(createChildMenuManager, createChildActions, null);
			}
			if (createSiblingMenuManager != null) {
				populateManager(createSiblingMenuManager, createSiblingActions, null);
			}
			
			// append 'Show properties view' action
			menu.insertAfter(ICommonMenuConstants.GROUP_ADDITIONS, showPropertiesViewAction);
		}
		
		updateGlobalActions(domain, (IStructuredSelection) selection);
		
		menu.add(undoAction);
	    menu.add(redoAction);
	    menu.add(deleteAction);
	}
	
	protected void updateGlobalActions(EditingDomain domain, IStructuredSelection selection) {
		// global actions
		deleteAction.setEditingDomain(domain);
		undoAction.setEditingDomain(domain);
		redoAction.setEditingDomain(domain);
		
//		deleteAction.updateSelection((IStructuredSelection) selection);
		undoAction.update();
		redoAction.update();		
	}
	
	protected void shareGlobalActions(IActionBars actionBars) {
		actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), deleteAction);
		actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), undoAction);
	    actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), redoAction);		
	}
	
	protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
		Collection<IAction> actions = new ArrayList<IAction>();
		if (descriptors != null) {
			for (Object descriptor : descriptors) {
				actions.add(new CreateChildAction(activePart, selection, descriptor));
			}
		}
		return actions;
	}
	
	protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
		Collection<IAction> actions = new ArrayList<IAction>();
		if (descriptors != null) {
			for (Object descriptor : descriptors) {
				actions.add(new CreateSiblingAction(activePart, selection, descriptor));
			}
		}
		return actions;
	}
	
	protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
		if (actions != null) {
			for (IAction action : actions) {
				if (contributionID != null) {
					manager.insertBefore(contributionID, action);
				}
				else {
					manager.add(action);
				}
			}
		}
	}
	
	@Override
	public void dispose() {
		this.selectionProvider.removeSelectionChangedListener(this);
		
		createChildMenuManager.dispose();
		createSiblingMenuManager.dispose();
		
		super.dispose();
	}

	@Override
	public void selectionChanged(SelectionChangedEvent event) {
		if (event.getSelection() instanceof IStructuredSelection && !event.getSelection().isEmpty()) {
			Object o = ((IStructuredSelection) event.getSelection()).getFirstElement();
			if (o instanceof EObject) {
				this.deleteAction.setEditingDomain(getEditingDomain((EObject) o));				
			}
		}
		this.deleteAction.selectionChanged(event);
	}
}
