package eu.qimpress.ide.backbone.core.ui.models.actions;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;


/**
 * 
 * @author Michal Malohlava
 *
 */
public class SammModelFamilyActionProvider extends CommonActionProvider {
	
	private boolean inViewPart = false;
	
	private SammModelFamilyActionsGroup sammModelFamilyActionsGroup;
		
	@Override
	public void init(ICommonActionExtensionSite aSite) {		
		super.init(aSite);
		
		ICommonViewerWorkbenchSite workbenchSite= null;
		if (aSite.getViewSite() instanceof ICommonViewerWorkbenchSite)
			workbenchSite= (ICommonViewerWorkbenchSite) aSite.getViewSite();

		if (workbenchSite != null) {
			if (workbenchSite.getPart() != null && workbenchSite.getPart() instanceof IViewPart) {
				IViewPart viewPart= (IViewPart) workbenchSite.getPart();
				
				this.sammModelFamilyActionsGroup = new SammModelFamilyActionsGroup(viewPart, aSite.getStructuredViewer());
				this.inViewPart = true;
			}
		}
	}
	
	@Override
	public void fillActionBars(IActionBars actionBars) {
		if (inViewPart) {
			sammModelFamilyActionsGroup.fillActionBars(actionBars);
		}
	}
	
	@Override
	public void fillContextMenu(IMenuManager menu) {
		if (inViewPart) {
			sammModelFamilyActionsGroup.fillContextMenu(menu);
		}
	}
	
	@Override
	public void setContext(ActionContext context) {		
		super.setContext(context);
		if (inViewPart) {
			sammModelFamilyActionsGroup.setContext(context);
		}
	}
	
	@Override
	public void dispose() {
		if (inViewPart) {
			sammModelFamilyActionsGroup.dispose();
		}
		super.dispose();		
	}	
}
