/**
 * 
 */
package eu.qimpress.ide.backbone.core.models.resources;

import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.BundleContext;

/**
 * @author Michal Malohlava
 *
 */
public class DefaultResourcesPlugin extends Plugin {
	
	public static final String PLUGIN_ID = "eu.qimpress.ide.backbone.core.models.resources";
	
	public static final String URI_DEVICE = "pathmap:";
	
	public static final String URI_ROOT = "//SAMM_DEFAULT_MODELS/";
	
	public static final String URI_MAPPING_PREFIX = URI_DEVICE + URI_ROOT;
	
	private static final String MODEL_DIR = "defaultModels";
	
	private List<String> defaultModels = new LinkedList<String>();
	
	private static DefaultResourcesPlugin plugin = null;
	
	@Override
	public void start(BundleContext context) throws Exception {
		super.start(context);
		
		initModelsList(context);
		
		plugin = this;
	}
	
	@Override
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		
		super.stop(context);
	}
	
	@SuppressWarnings("unchecked")
	private void initModelsList(BundleContext context) {
		Enumeration entries = context.getBundle().findEntries(MODEL_DIR, "*.*", false);
		
		for(; entries.hasMoreElements(); ) {
			URL url = (URL) entries.nextElement();		
			String modelName = new Path(url.getFile()).lastSegment();
			if (!modelName.startsWith(".") && !modelName.startsWith("README.txt")) { 
				defaultModels.add(new Path(url.getFile()).lastSegment());
			}
		}
	}
	
	public String[] getAccesibleModels() {
		return defaultModels.toArray(new String[defaultModels.size()]);		
	}
	
	public URI getModelURI(String modelName) {
		return URI.createURI(URI_MAPPING_PREFIX + modelName, true);				
	}
	
	public static DefaultResourcesPlugin getDefault() {
		return plugin;
	}
}
