/**
 * 
 */
package eu.qimpress.ide.backbone.project.adapters;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.NodeAdapter;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

import eu.qimpress.ide.backbone.project.listeners.XtextResourceChangeListener;
import eu.qimpress.samm.core.NamedEntity;

/**
 * @author Michal Malohlava
 *
 */
public class XtextResourceBasedConcreteSyntaxFile implements IConcreteSyntaxFile {
	
	private static final Logger logger = Logger.getLogger(XtextResourceBasedConcreteSyntaxFile.class);
	
	private NamedEntity namedEntity;	
	private IFile outputFile;
	
	private Resource ecoreResource;
	private Resource xtextResource;
	
	private IResourceChangeListener resourceChangeListener;
	
	private IPartListener partListener;	
	
	public XtextResourceBasedConcreteSyntaxFile(NamedEntity namedEntity, IFile outputFile) {		
		this.namedEntity = namedEntity;
		this.outputFile = outputFile;
		this.ecoreResource = namedEntity.eResource(); 
	}

	/* (non-Javadoc)
	 * @see eu.qimpress.ide.backbone.project.adapters.IConcreteSyntaxFile#getFile()
	 */
	@Override
	public IFile generate() throws Exception {
		try {
			// produce concrete syntax file
			logger.trace("Generating file with concrete syntax");
			doGenerate();
		} catch (Exception e) {
			logger.error("Cannot serialize model element " + this.namedEntity + "to file.", e);
			
			throw e;
		}
		
		return this.outputFile;		
	}
	
	protected void doGenerate() throws IOException {
		// TODO reimplement with help of eclipse serializer ?
		
		// create temporary DSL
//		ShadowModelEditor shadowModelEditor = ShadowModelEditorUtils.getShadowModelEditor(namedEntity.eResource());
//		this.xtextResource = shadowModelEditor.getEditingDomain().getResourceSet().createResource(URI.createURI(outputFile.getLocationURI().toString()));
		XtextResourceSet xrs = new XtextResourceSet();
		this.xtextResource = xrs.createResource(URI.createURI(outputFile.getLocationURI().toString()));
		// save resource - it is used original resource				
		this.xtextResource.getContents().addAll(EcoreUtil.copyAll(this.ecoreResource.getContents()));
		Map<String, Boolean> options = new HashMap<String, Boolean>();
		options.put(XtextResource.OPTION_FORMAT, Boolean.TRUE);
		options.put(XtextResource.OPTION_RESOLVE_ALL, Boolean.TRUE);
				
		this.xtextResource.save(options);
		// just for make sure that serialization was successful and obtain all adapters containing parsing information
		this.xtextResource.unload();
		this.xtextResource.load(null);					
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	@Override
	public void dispose() {
		// remove listener
		if (this.resourceChangeListener != null) {
			ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
			logger.trace(" - resource listener unregistered");
		}
		
		// remove listener listening on this resource
		if (this.partListener != null) {
			IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
			activePage.removePartListener(this.partListener);
			logger.trace(" - part listener unregistered");
		}
		
		try {
			this.outputFile.delete(true, null);
		} catch (CoreException e) {			
			// ignoring exception
			logger.warn("Cannot delete temporary file with concrete syntax: " + this.outputFile, e);
		}
		
	}
	
	@Override
	public Resource getOriginalResource() {		
		return this.ecoreResource;
	}
	
	@Override
	public Resource getConcreteResource() {
		return this.xtextResource;
	}
	
	@Override
	public IFile getOutputFile() {
		return outputFile;
	}

	@Override
	public void openInEditor(String editorId) throws PartInitException {
		// prepare editor input
		IEditorInput editorInput = new FileEditorInput(this.outputFile) {
			
			@Override
			public String getName() {				
				return XtextResourceBasedConcreteSyntaxFile.this.namedEntity.eClass().getName() + " " + XtextResourceBasedConcreteSyntaxFile.this.namedEntity.getName();				
			}
		};		
		
		// open editor
		IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();		
		IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
		IEditorPart editor = workbenchPage.openEditor(editorInput, editorId);		
		logger.trace("Editor opened: " + editorId);
		
		// select area with entity definition in editor
		selectEntityInEditor((ITextEditor) editor);
		// register change listener
		registerListeners();
			
	}
	
	protected void selectEntityInEditor(ITextEditor textEditor) {
		NodeAdapter nodeAdapter = NodeUtil.getNodeAdapter(this.xtextResource.getEObject(namedEntity.getId()));
		if (nodeAdapter != null) {
			CompositeNode parserNode = nodeAdapter.getParserNode();
			if (parserNode != null) {
				if (parserNode != null) {					
					textEditor.getSelectionProvider().setSelection(
							new TextSelection(parserNode.getOffset(),
									parserNode.getLength()));
				}
			}
		}						
	}
	
	protected void registerListeners() {
		logger.trace(" - registering resource listener");		
		this.resourceChangeListener = new XtextResourceChangeListener(this);
		ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, IResourceChangeEvent.POST_CHANGE);
		
		logger.trace(" - registering part listener");
		this.partListener = (IPartListener) this.resourceChangeListener;		
		IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
		activePage.addPartListener(this.partListener);			
	}
	
}
