/**
 * 
 */
package eu.qimpress.ide.backbone.core.operations;

import java.lang.reflect.InvocationTargetException;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.RepositoryException;

/**
 * Save the given model operation from UI. 
 * 
 * To invoke operation, call method {@link #run(IProgressMonitor)}
 *  
 * @see WorkspaceModifyOperation
 * @author Michal Malohlava
 *
 */
public class SaveQModelUIOperation extends WorkspaceModifyOperation {
	
	private static final Logger logger = Logger.getLogger(SaveQModelUIOperation.class);
	
	private IQModel qModel;
	
	public SaveQModelUIOperation(IQModel qModel) {
		this.qModel = qModel;		
	}

	@Override
	protected void execute(IProgressMonitor monitor) throws CoreException,
			InvocationTargetException, InterruptedException {
		try {
			// save model
			qModel.save();
			
			// NOTE: update of markers is not needed it is handled by ShadowModelEditor and its listener to modified models
						
		} catch (RepositoryException e) {
			logger.error("Cannot save model: " + qModel, e);
			
			throw new InvocationTargetException(e);			
		} finally {
			monitor.done();
		}		
	}

}
