/**
 * 
 */
package eu.qimpress.ide.backbone.core.operations;

import java.lang.reflect.InvocationTargetException;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;

/**
 * @author Michal Malohlava
 *
 */
public class CreateQAlternativeUIOperation extends WorkspaceModifyOperation {
	
	private static final Logger logger = Logger.getLogger(CreateQAlternativeUIOperation.class);
	
	String alternativeName;	
	Object alternativeParent;
	
	public CreateQAlternativeUIOperation(String alternativeName, Object alternativeParent) {
		this.alternativeName = alternativeName;
		this.alternativeParent = alternativeParent;
	}

	@Override
	protected void execute(IProgressMonitor monitor) throws CoreException,
			InvocationTargetException, InterruptedException {
		
		try {
			IQAlternative qAlternative = null;
			if (alternativeParent instanceof IQAlternative) {
				qAlternative = createAlternative(alternativeName, (IQAlternative) alternativeParent);
			} else if (alternativeParent instanceof IQRepository) {
				qAlternative = createAlternative(alternativeName, (IQRepository) alternativeParent);
			} else if (alternativeParent instanceof IProject) {
				qAlternative = createAlternative(alternativeName, (IProject) alternativeParent);			
			}
			
			fireUpdates(qAlternative);					
			
		} catch (Exception e) {
			logger.error("Cannot create new alternative", e);			
		} finally {
			monitor.done();
		}
	}
	
	private IQAlternative createAlternative(String alternativeName, IProject project) throws RepositoryException {
		IQProject qProject = QImpressApplicationModelManager.getManager().getQAppModel().getQProject(project);
		if (qProject != null && qProject.getRepository() != null) {
			return createAlternative(alternativeName, qProject.getRepository());
		}
		return null;		
		
	}

	private IQAlternative createAlternative(String alternativeName, IQRepository repo) throws RepositoryException {
		IQAlternative qAlt = repo.createAlternative(alternativeName);
		
		return qAlt;
	}

	private IQAlternative createAlternative(String alternativeName, IQAlternative alt) throws RepositoryException {
		IQRepository repo = alt.getRepository();
		IQAlternative qAlt = repo.createAlternative(alt, alternativeName);
		
		return qAlt;
	}
	
	private void fireUpdates(IQAlternative qAlt) {
		IQApplicationModel appModel = QImpressApplicationModelManager.getManager().getQAppModel();

		appModel.fireAlternativeCreated(qAlt);
		appModel.fireRefresh();
	}
}
