/* $Id$ */
package eu.qimpress.ide.backbone.core.model;

import org.eclipse.emf.ecore.EObject;

/**
 * Constants with predefined names of the models.
 * 
 * TODO - get this information via extension point
 * org.eclipse.emf.ecore.extension_parser
 * 
 * @author Petr Hnetynka
 */

public class RepositoryModels {

	/* Enable model extensions */
	/** Annotation structure model file extension. */
	public static final String ANNOTATION_MODEL_EXT = "samm_qosannotation";
	/** Static structure model file extension. */
	public static final String REPOSITORY_MODEL_EXT = "samm_repository";
	/** SEFF behavior model file extension. */
	public static final String SEFF_BEHAVIOR_MODEL_EXT = "samm_seff";
	/** Target environment model file extension */
	public static final String TARGET_ENVIRONMENT_MODEL_EXT = "samm_targetenvironment";
	/** Hardware model file extension */
	public static final String HARDWARE_MODEL_EXT = "samm_hardware";
	/** Usage model file extension */
	public static final String USAGE_MODEL_EXT = "samm_usagemodel";
	/** Service architecture model file extension */
	public static final String SERVICE_ARCHITECTURE_MODEL_EXT = "samm_servicearchitecturemodel";
	/** Data types model file extension */
	public static final String DATA_TYPES_MODEL_EXT = "samm_datatypes";
	/** Behaviour model extension */
	public static final String BEHAVIOR_MODEL_EXT = "samm_behaviour";
	/** Allocation model extension */
	public static final String ALLOCATION_MODEL_EXT = "samm_allocation";
	
	public static final String SAMMDECORATOR_MODEL_EXT = "sammdecorator";
	
	public static final String RESULT_MODEL_EXT = "samm_resultmodel";
	
	public static final String GLOBAL_REPOSITORY_MODEL_NAME = "global_result_repository";
	
	public static final String USAGE_MODEL_NAME = "usage_model";
	
	public static final String GAST_STUB_BEHAVIOUR_EXTENSION = "samm_gastbehaviour";
	
	public static final String SOURCECODE_DECORATOR_EXTENSION = "sourcecodedecorator";
	
	public static final String GAST_EXTENSION = "gast";


	/** Enabled model extensions */
	public static final String[] MODEL_EXTENSIONS = {
		ANNOTATION_MODEL_EXT,
		REPOSITORY_MODEL_EXT,
		SEFF_BEHAVIOR_MODEL_EXT,
		TARGET_ENVIRONMENT_MODEL_EXT,
		HARDWARE_MODEL_EXT,
		USAGE_MODEL_EXT,
		SERVICE_ARCHITECTURE_MODEL_EXT,
		DATA_TYPES_MODEL_EXT,
		BEHAVIOR_MODEL_EXT,		
		ALLOCATION_MODEL_EXT,
		SAMMDECORATOR_MODEL_EXT,
		RESULT_MODEL_EXT
	};
	
	public static boolean isSupportedFileExtension(String extension) {
		for (String ext : MODEL_EXTENSIONS) {
			if (ext.equals(extension)) {
				return true;
			}
		}
//		return false;
		return true;
	}
	
	public static final String getModelExtension(EObject eo) {		
		// TODO obtain model extension from extension point
		return null;		
	}
}
