/**
 * 
 */
package eu.qimpress.ide.backbone.core.model;


import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

import eu.qimpress.ide.backbone.core.QImpressCore;

/**
 * Model provider for Q-ImPrESS application.
 * 
 * Model consists of:
 *   <ul>
 *   <li>alternatives</li>
 *   <li>model repositories</li>
 *   <li>Q-ImPrESS projects</li>
 *   </ul>
 * @author Michal Malohlava
 *
 */
public class QImpressApplicationModelProvider extends ModelProvider {
	
	/** Q-ImpReSS application model provider ID */
	public static final String QIMPRESS_APP_MODEL_PROVIDER_ID = QImpressApplicationModelProvider.class.getCanonicalName();
	
	public QImpressApplicationModelProvider() {	
	}
	
	public static IResource getResource(final Object element) {
		IResource resource = null;
		
		if (element instanceof IQElement) {
			resource = ((IQElement) element).getCorrespondingResource();
		} else if (element instanceof IResource) {
			resource = (IResource) element;
		} 
		
		return resource;
	}
	
	@Override
	public ResourceMapping[] getMappings(IResource resource,
			ResourceMappingContext context, IProgressMonitor monitor)
			throws CoreException {
		
		final IQElement element = QImpressCore.create(resource);		
		if (element != null) {
			return new ResourceMapping[] {QElementResourceMapping.create(element)};
		}
		
		final Object adapted = resource.getAdapter(ResourceMapping.class);
		if (adapted instanceof ResourceMapping) {
			return new ResourceMapping[] {(ResourceMapping) adapted};
		}
			
		return new ResourceMapping[] { /* new QImpressResourceMapping(resource) */};
	}
}
