/**
 * 
 */
package eu.qimpress.ide.backbone.core.model;


import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.internal.model.QApplicationModelImpl;
import eu.qimpress.ide.backbone.core.internal.model.QDirectoryRepositoryImpl;
import eu.qimpress.ide.backbone.core.internal.model.QModelImpl;

/**
 * Singleton class to obtain Q-ImPrESS application model. 
 * There is only one such model including Q-Impress projects further including model alternatives and repositories.
 *   
 * @author Michal Malohlava
 *
 */
public class QImpressApplicationModelManager {
	
	private static Logger logger = Logger.getLogger(QImpressApplicationModelManager.class);
	
	/**
	 * Unique handle onto the QImpress application model {@link QApplicationModelImpl} 
	 */
	private final IQApplicationModel qAppModel = new QApplicationModelImpl(); 
	
	/**
	 * The singleton manager.
	 */
	private static QImpressApplicationModelManager MANAGER = new QImpressApplicationModelManager();
		
	public static final QImpressApplicationModelManager getManager() {
		return MANAGER;
	}
	
	private QImpressApplicationModelManager() {		
	}	
	
	public IQApplicationModel getQAppModel() {
		return this.qAppModel;		
	}

	public static IQElement create(IResource resource, IQProject qProject) {
		logger.trace("create method call for resource="+resource+" and qproject="+qProject);
		if (resource == null) {
			return null;
		}
		
		int type = resource.getType();		
		switch (type) {
		case IResource.PROJECT:
			return QImpressCore.create((IProject) resource);
		case IResource.ROOT:
			return QImpressCore.create((IWorkspaceRoot) resource, qProject);
		case IResource.FOLDER:
			return QImpressCore.create((IFolder) resource, qProject);
		case IResource.FILE:
			return QImpressCore.create((IFile) resource, qProject);
		default:
			return null;
		}
	}
	
	public static IQElement create(IFolder folder, IQProject project) {
		if (folder == null) {
			return null;
		}
		
		if (project == null) {
			project = QImpressCore.create(folder.getProject());			
		}
		
		IQRepository repository = null;		
		try {
			repository = project.getRepository(folder);
		} catch (RepositoryException e) {
			e.printStackTrace();
		}
		
		return repository;
	}
	
	public static IQElement create(IFile file, IQProject project) {
		if (file == null) { 
			return null;
		}
		
		if (project == null) {
			project = QImpressCore.create(file.getProject());
		}
		
		if (RepositoryModels.isSupportedFileExtension(file.getFileExtension())) {	
			// FIXME put here appropriate alternative instead of null
			return new QModelImpl(file, null);
		} else {
			return null;
		}
	}
	
	public static IQModel getModelByResource(IFile file) {
		
		if (file.getParent() != null && file.getParent().exists()
				&& file.getParent().getParent() != null && file.getParent().getParent().getName().equals(QDirectoryRepositoryImpl.DEFAULT_REPOSITORY_LOCATION)) {			
			IQProject qProject = QImpressCore.getQProject(file.getProject());
			
			String alternativeId = file.getParent().getName();
			
			IQAlternative qAlternative = null;			
			try {
				qAlternative = qProject.getRepository().getAlternative(alternativeId);			
			
				if (qAlternative != null) {
					IQModel[] models = qAlternative.getModels(true);
					for (IQModel model : models) {
						if (model.getCorrespondingResource().equals(file)) {
							return model;
						}
					}
				}
			} catch (RepositoryException e) {
				logger.warn("Cannot get alternative by id: " + alternativeId, e);
			}
		}
		
		return null;				
	}
}
 