/**
 * 
 */
package eu.qimpress.ide.backbone.core.model;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;


/**
 * 
 * @author Michal Malohlava
 *
 */
public abstract class QElementResourceMapping extends ResourceMapping {
	
	protected QElementResourceMapping() {}
	
	public IQElement getQElement() {
		Object o = getModelObject();
		if (o instanceof IQElement) { 
			return (IQElement) o;
		}
		
		return null;
	}
	
	public boolean equals(Object obj) {
		if (!(obj instanceof QElementResourceMapping))
			return false;
		return getQElement().equals(((QElementResourceMapping)obj).getQElement());
	}

	public int hashCode() {
		IQElement qAppElement= getQElement();
		if (qAppElement == null)
			return super.hashCode();

		return qAppElement.hashCode();
	}

	@Override
	public String getModelProviderId() {		
		return QImpressApplicationModelProvider.QIMPRESS_APP_MODEL_PROVIDER_ID;
	}
	
	// factory methods ---->
	public static ResourceMapping create(final IQElement element) {
		switch (element.getElementType()) {
		case Q_APPLICATION_MODEL:
			return create((IQApplicationModel) element);
		case Q_REPOSITORY:
			return create((IQRepository) element);
		case Q_PROJECT:
			return create((IQProject) element);
		case Q_ALTERNATIVE:
			return create((IQAlternative) element);
		case Q_MODEL:
			return create((IQModel) element);
		default:
			return null;
		}
	}
	
	public static ResourceMapping create(final IQApplicationModel model) {
		return new QAppModelResourceMapping(model);
	}
	
	public static ResourceMapping create(final IQProject project) {
		return new QProjectResourceMapping(project);
	}
	
	public static ResourceMapping create(final IQRepository repository) {
		return new QRepositoryResourceMapping(repository);
	}
	
	public static ResourceMapping create(final IQAlternative alternative) {
		return new QAlternativeResourceMapping(alternative);
	}
	
	public static ResourceMapping create(final IQModel model) {
		return null;
	}
	
	
	
	// --- particular resource mappings
	private static final class QAppModelResourceMapping extends QElementResourceMapping {
		private final IQApplicationModel qAppModel;
		
		private QAppModelResourceMapping(IQApplicationModel qAppModel) {
			super();
			this.qAppModel = qAppModel;
		}

		@Override
		public Object getModelObject() {			
			return qAppModel;
		}

		@Override
		public IProject[] getProjects() {
			IQProject[] qProjects = qAppModel.getQProjects();
			
			IProject[] result = new IProject[qProjects.length];
			int i = 0;
			for (IQProject project : qProjects) {
				result[i++] = project.getProject();
			}
			
			return result;
		}

		@Override
		public ResourceTraversal[] getTraversals(
				ResourceMappingContext context, IProgressMonitor monitor)
				throws CoreException {
			
			IQProject[] qProjects = qAppModel.getQProjects();
			ResourceTraversal[] result = new ResourceTraversal[qProjects.length];
			int i = 0;
			for(IQProject p : qProjects) {
				result[i++] = new ResourceTraversal(new IResource[] {p.getProject()}, IResource.DEPTH_INFINITE, 0); 				
			}
			
			return result;
		}
	}
	
	private static final class QProjectResourceMapping extends QElementResourceMapping {
		
		private final IQProject qProject;
		
		private QProjectResourceMapping(IQProject qAppProject) {
			this.qProject = qAppProject;
		}

		@Override
		public Object getModelObject() {
			return qProject;
		}

		@Override
		public IProject[] getProjects() {
			return new IProject[] { qProject.getProject() };			
		}

		@Override
		public ResourceTraversal[] getTraversals(
				ResourceMappingContext context, IProgressMonitor monitor)
				throws CoreException {
			
			return new ResourceTraversal[] { 
					new ResourceTraversal(new IResource[] {qProject.getProject()}, IResource.DEPTH_INFINITE, 0)
			};
		}		
	}
	
	private static final class QRepositoryResourceMapping extends QElementResourceMapping {
		
		private final IQRepository qRepository;
		
		public QRepositoryResourceMapping(IQRepository repository) {		
			this.qRepository = repository;
		}

		@Override
		public Object getModelObject() {
			return this.qRepository;
		}

		@Override
		public IProject[] getProjects() {			
			return new IProject[] { this.qRepository.getRepositoryFolder().getProject() };
		}

		@Override
		public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor)
				throws CoreException {			
			return new ResourceTraversal[] { 
					new ResourceTraversal(new IResource[] {qRepository.getCorrespondingResource()}, IResource.DEPTH_INFINITE, 0)
			};
		}
		
	}
	
	
	private static final class QAlternativeResourceMapping extends QElementResourceMapping {
		private final IQAlternative qAlternative;
		
		private QAlternativeResourceMapping(IQAlternative qAlternative) {
			this.qAlternative = qAlternative;
		}

		@Override
		public Object getModelObject() {			
			return qAlternative;
		}

		@Override
		public IProject[] getProjects() {			
			return new IProject[] { qAlternative.getAlternativeFolder().getProject() };
		}

		@Override
		public ResourceTraversal[] getTraversals(
				ResourceMappingContext context, IProgressMonitor monitor)
				throws CoreException {			
			return new ResourceTraversal[] { 
					new ResourceTraversal(new IResource[] {qAlternative.getCorrespondingResource()}, IResource.DEPTH_INFINITE, 0)
			};
		}
		
	}
	

}
