/**
 * 
 */
package eu.qimpress.ide.backbone.core.model;

/**
 * This interface exhibit a contract of parameters providers.
 * 
 * @author Michal Malohlava
 * 
 */
public interface IQParameterProvider {

	/**
	 * Returns a value of parameter with given key.
	 * 
	 * @param key parameter key
	 * @return value of parameter or <code>null</code> if the parameter of given
	 *         key does not exist
	 * 
	 */
	Object getParameter(String key);

	/**
	 * Associates parameter value with the given parameter key.
	 * 
	 * @param key parameter key
	 * @param value parameter value
	 * 
	 */
	void setParameter(String key, Object value) ;

	/**
	 * Returns true if parameter with given key exists else returns false
	 * 
	 * @param key parameter key
	 * @return true if parameter with given key exists else returns false
	 */
	boolean containsKey(String key) ;
}
