package eu.qimpress.ide.backbone.core.model;

import java.util.EventListener;

/**
 * A listener to be notified when refresh of the application model is needed.
 * 
 * @author Tomas Bures
 *
 */
public interface IQApplicationModelChangeListener extends EventListener {

	/**
	 * Called to indicate the refresh of the application model is needed.
	 */
	void refresh();
	
	/**
	 * Called after a new alternative has been created.
	 *  
	 * @param alternative the alternative
	 */
	void alternativeCreated(final IQAlternative alternative);
			
	/**
	 * Called after a set of new models has been created.
	 * 
	 * @param models newly created models
	 */
	void modelCreated(final IQModel[] models);
	
	/**
	 * Called after a set of model has been modified. Does not contain newly created models.
	 * 
	 * @param models modified models
	 */	
	void modelModified(final IQModel[] models);
	
	/**
	 * Called after a set of models has been deleted.
	 * 
	 * @param models list of deleted models
	 */
	void modelDeleted(final IQModel[] models);
}
