/**
 * 
 */
package eu.qimpress.ide.backbone.core.model;

/**
 * @author Michal Malohlava
 *
 */
public interface IQAlternativeInfo {
	
	/**
	 * Marks default alternative. 
	 * 
	 * @return true if the alternative is a default alternative
	 */
	boolean isDefault();
	
	/**
	 * Set this alternative default.
	 */
	void setDefault(boolean shouldBeDefault);

	/**
	 * Returns ID of the alternative. The ID is a globally unique string.
	 * 
	 * @return ID of the alternative
	 */
	String getId();

	/**
	 * Returns a human readable description of the alternative.
	 * 
	 * @return a human readable description of the alternative
	 */
	String getDescription();

	/**
	 * Returns a timestamp of the alternative.
	 * 
	 * @return a timestamp of the alternative
	 */
	java.util.Date getCreationDate();

	/**
	 * Returns a parent alternative if any.
	 * 
	 * @return a parent alternative or <code>null</code>
	 */
	IQAlternativeInfo getParentAlternative();	
}
