/**
 * 
 */
package eu.qimpress.ide.backbone.core.internal.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.RepositoryException;

/**
 * Model implementation.
 * 
 * @author Petr Hnetynka
 * @author Michal Malohlava
 */
public class QModelImpl extends QElement implements IQModel {
	
	private static final Logger logger = Logger.getLogger(QModelImpl.class);

	private IFile repositoryFile;
	private String name;
	private IQAlternative alternative;
	private boolean deleted;

	public QModelImpl(IFile repoFile, IQAlternative alternative) {
		this(repoFile, repoFile.getFileExtension(), alternative);		
	}
	
	public QModelImpl(IFile repoFile, String name, IQAlternative alternative) {
		super(alternative);
				
		this.name = name;		
		this.repositoryFile = repoFile;
		this.alternative = alternative;
	}

	@Override 
	public IQAlternative getAlternative() {
		return alternative;
	}
	
	@Override
	public IResource getCorrespondingResource() {		
		return repositoryFile;
	}

	@Override
	public ElementType getElementType() {		
		return ElementType.Q_MODEL;
	}

	@Override
	public InputStream getInputStream() throws IOException {		
		InputStream result = null;
		if (repositoryFile.exists()) {
			try {
				return repositoryFile.getContents();
			} catch (CoreException e) {
				throw new IOException(e);
			}
		}
		return result;
	}

	@Override
	public String getName() {		
		return repositoryFile.getName();
	}
	
	@Override
	public String getType() {		
		return repositoryFile.getFileExtension();
	}

	@Override
	public OutputStream getOutputStream() throws IOException {		
		return null;
	}

	@Override
	public EObject getTopLevelEObject() {
		return getTopLevelEObject(EObject.class);
	}
	
	@Override
	public <T extends EObject> T getTopLevelEObject(Class<T> clazz) {		
		return getTopLevelEObject(clazz, null);
	}
	
	@SuppressWarnings("unchecked")
	public <T extends EObject> T getTopLevelEObject(Class<T> clazz, EClass eclazz) {
		T topLevelEObject = null;
		Resource resource = (Resource) this.getAdapter(Resource.class);
		if (resource != null) {		
			if (!resource.getContents().isEmpty()) {
				topLevelEObject = (T) resource.getContents().get(0);
			} else if (eclazz != null) {
				topLevelEObject = (T) eclazz.getEPackage().getEFactoryInstance().create(eclazz);
				resource.getContents().add(topLevelEObject);
			} else {
				logger.debug("The top-level EObject is not created for IQModel: " + this);
			}
		} else {
			logger.warn("Cannot get EMF resource for the IQModel: " + this);
		}
				
		return topLevelEObject;
		
	}
	
	@Override
	public void delete() throws RepositoryException {
		if (!repositoryFile.exists()) {
            throw new IllegalStateException("Model is already deleted.");
	    }
		
		internalDelete();
		((eu.qimpress.ide.backbone.core.internal.model.QAlternativeImpl) alternative).internalDelete(this.name);	
	}
	
	void internalDelete() throws RepositoryException {
		try {
		  repositoryFile.delete(true, false, null);
		  deleted = true;
		} catch (CoreException ex) {
			throw new RepositoryException("Model cannot be deleted.", ex);
		}
	}

	@Override
	public String toString() {
		return "QModelImpl [name=" + name + ", repositoryFile="
				+ repositoryFile + "]";
	}
	
	/**
	 * This method should be called with help of WorkspaceModifyOperation
	 */
	@Override
	public void save() throws RepositoryException {
		Resource resource = (Resource) this.getAdapter(Resource.class);
		if (resource != null) {
			
			try {
				resource.save(null);
			} catch (IOException e) {
				logger.error("Model save failed - cannot save EMF resource for the IQModel: " + this);
				throw new RepositoryException("Cannot save EMF resource for model: " + this);
			}
			
		} else {
			logger.error("Model save failed - cannot get EMF resource for the IQModel: " + this);
			throw new RepositoryException("Cannot obtain EMF resource for model: " + this);
		}
		
	}
}
