/**
 * 
 */
package eu.qimpress.ide.backbone.core.internal.model;


import org.eclipse.core.runtime.PlatformObject;

import eu.qimpress.ide.backbone.core.model.IQElement;

/**
 * @author Michal Malohlava
 *
 */
public abstract class QElement extends PlatformObject implements IQElement {

	/** This element parent or null if this element has no parent */
	/* package */ IQElement parent;
	
	protected static final IQElement[] NO_CHILDREN = new IQElement[] {}; 
	
	public QElement(IQElement parent) {
		super();		
		this.parent = parent;
	}
	
	@Override
	public IQElement getParent() {		
		return this.parent;
	}
	
	/**
	 * @see eu.qimpress.ide.backbone.core.model.IParent#getChildren()
	 */
	public IQElement[] getChildren() {
		return NO_CHILDREN;
	}
	
	/**
	 * @see eu.qimpress.ide.backbone.core.model.IParent#hasChildren()
	 */
	public boolean hasChildren() {
		return false;
	}
}
