/**
 * 
 */
package eu.qimpress.ide.backbone.core.internal.listeners;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;

import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;

/**
 * Q-ImPrESS model resource change listener for Q-I project closing and deleting .
 * 
 * It listens to changes at Q-I projects and performs appropriate actions (i.e.,
 * deletion of project means closing alternatives database.)
 * 
 * @author Michal Malohlava
 * 
 */
public class QImpressProjectlResourceChangedListener implements
		IResourceChangeListener {

	private static final Logger logger = Logger
			.getLogger(QImpressProjectlResourceChangedListener.class);

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.core.resources.IResourceChangeListener#resourceChanged(org
	 * .eclipse.core.resources.IResourceChangeEvent)
	 */
	@Override
	public void resourceChanged(IResourceChangeEvent event) {
		if (event.getType() == IResourceChangeEvent.PRE_DELETE
				||
			event.getType() == IResourceChangeEvent.PRE_CLOSE) {
			
			IResource resource = event.getResource();
			logger.trace("PRE_DELETE event received on resource " + resource);
			if (resource != null && resource.getType() == IResource.PROJECT) {
				IProject project = (IProject) resource;
				
				handleProjectDelete(project);				
			}

		}
	}

	protected void handleProjectDelete(IProject project) {		
		try {			
			IQApplicationModel qAppModel = QImpressApplicationModelManager
			.getManager().getQAppModel(); 
			IQProject qProject = qAppModel.getQProject(project);
	
			if (qProject != null) {
				logger.trace("PRE_DELETE event performed on Q-I project "
						+ qProject);
				
				// close repository and remove project
				qAppModel.removeQProject(project);
				
				// TODO FEATURE check if we need somehow to unload ShadowModelEditor
				
			}
		} catch (RepositoryException e) {
			logger.error("Cannot close repository object for Q-I project: "
					+ project, e);
		}
	}
}
