/*
 * (C) Copyright IBM Corp. 2002 - All Rights Reserved. 
 * Licensed Material - Property of IBM 
 */
 
package eu.qimpress.ide.backbone.core.ui.wizards;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

import eu.qimpress.ide.backbone.core.operations.InitializeQImpressProjectOperation;
import eu.qimpress.ide.backbone.core.ui.perspectives.QIPerspective;
import eu.qimpress.ide.backbone.core.utils.ProjectUtils;


/**
 * New Q-ImPrESS project wizard implementation.
 * 
 * @author Michal Malohlava
 */
public class QImPrESSNewProjectWizard extends BasicNewProjectResourceWizard
{	
	private final static Logger logger = Logger.getLogger(QImPrESSNewProjectWizard.class);
	
	public static final String WIZARD_ID = "eu.qimpress.ide.backbone.core.ui.QImPrESSNewProjectWizardID";
	
	public boolean performFinish() 
	{		
		if(super.performFinish()) {
			final IProject project = getNewProject();
			
			try {
				logger.trace("Trying to toggle Q-ImPrESS nature");
				
				// configure project workspace
				WorkspaceModifyOperation operation = new InitializeQImpressProjectOperation(project);				
				// execute operation
				getContainer().run(false, false, operation);
				
				// toggle Q-I nature
				ProjectUtils.toggleNature(project);
				
				// open the perspective
				IWorkbench workbench = PlatformUI.getWorkbench();
				IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
				workbench.showPerspective(QIPerspective.PERSPECTIVE_ID, window);
				
			} catch (Exception e) {
				logger.error("Cannot toggle Q-Impress nature for project " + project, e);
				MessageDialog.openError(getShell(), "Q-ImPrESS project creation failed", "Q-ImPrESS nature toggling failed - see log for details");
				
				// TODO delete the created project
			}
			
			return true;
		}
		
		return false;
	}
}
