/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.wizards;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

import eu.qimpress.ide.backbone.core.model.IQAlternative;

/**
 * @author Michal Malohlava
 *
 */
public class NewQAlternativePage2 extends AbstractQAlternativePage {
	
	Text alternativeNameField;	
	
	protected NewQAlternativePage2(IQAlternative parentAlternative) {
		super(parentAlternative, "Create new alternative", SELECT_ALTERNATIVES.SELECT_ONE);
		
		setTitle("Create new alternative");
		setDescription("Select parent for new alternative and its name");
		setPageComplete(false);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createControl(Composite parent) {
		super.createControl(parent);
		// Alternative name label ...
		Label alternativeNameLabel = new Label((Composite)getControl(), SWT.NONE);
		alternativeNameLabel.setText("Name");
		GridDataFactory.generate(alternativeNameLabel, 1, 1);
		
		// Alternative name field
		alternativeNameField = new Text((Composite)getControl(), SWT.BORDER);
		alternativeNameField.addListener(SWT.Modify, new Listener() {
			
			@Override
			public void handleEvent(Event e) {				
				boolean valid = validatePage();
				setPageComplete(valid);
			}			
		});
		GridDataFactory.generate(alternativeNameField, 3, 1);
	}
	
	public String getAlternativeName() {
		return alternativeNameField.getText();
	}

}
