/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.wizards;

import javax.lang.model.element.Element;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativesTreeViewerFactory;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativesTreeViewerFactory.SelectAlternativesEnum;

/**
 * @author Michal Malohlava
 *
 */
public class NewQAlternativePage extends WizardPage {
	
	Text alternativeNameField;
	TreeViewer alternativeViewer;
	
	private IQElement parentElement; 

	protected NewQAlternativePage(IQElement parentElement) {
		super("Create new alternative");
		
		setTitle("Create new alternative");
		setDescription("Select parent for new alternative and its name");
		setPageComplete(false);
		
		this.parentElement = parentElement;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createControl(Composite parent) {
		final Composite composite = new Composite(parent, SWT.NULL);
		
		initializeDialogUnits(parent);
		composite.setLayout(new GridLayout(4, false));

		setControl(composite);
		
		// Parent element label ...
		Label parentAlternativeLabel = new Label(composite, SWT.NONE);
		parentAlternativeLabel.setText("Parent alternative");
		GridDataFactory.generate(parentAlternativeLabel, 1, 1);
		
		// Alternative tree viewer
		
		alternativeViewer = QAlternativesTreeViewerFactory
							.createTreeViewer(composite, SelectAlternativesEnum.SELECT_ONE)
							.setParentElement(parentElement)
							.getTreeViewer();		
		GridDataFactory.generate(alternativeViewer.getControl(), 3, 1);
		
		// Alternative name label ...
		Label alternativeNameLabel = new Label(composite, SWT.NONE);
		alternativeNameLabel.setText("Name");
		GridDataFactory.generate(alternativeNameLabel, 1, 1);
		
		// Alternative name field
		alternativeNameField = new Text(composite, SWT.BORDER);
		alternativeNameField.addListener(SWT.Modify, new Listener() {
			
			@Override
			public void handleEvent(Event e) {				
				boolean valid = validatePage();
				setPageComplete(valid);
			}			
		});
		GridDataFactory.generate(alternativeNameField, 3, 1);		
	}	
	
	/**
	 * Return reference to an parent alternative or null if the alternative shoudl be top-level.
	 * 
	 * @return
	 */
	public IStructuredSelection getAlternativeParentSelection() {
		ISelection selection = alternativeViewer.getSelection();
		
		if (selection instanceof IStructuredSelection && ((IStructuredSelection) selection).size() == 1) {
			return (IStructuredSelection) selection;			
		}
		
		return null;
	}
	
	public String getAlternativeName() {
		return alternativeNameField.getText();
	}
	
	protected boolean validatePage() {
		String altName = getAlternativeName();
		
		setErrorMessage(null);
		setMessage(null);
		
		if (altName == null || altName.equals("")) {
			setErrorMessage("Alternative name cannot be null!");
			
			return false;
		}
		
		if (getAlternativeParentSelection() == null) {
			setErrorMessage("Parent alternative or alternative repository/project has to be selected!");
		}
		
		return true;
	}
}
