package eu.qimpress.ide.backbone.core.ui.wizards;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.ui.QAppNavigatorContentProvider;
import eu.qimpress.ide.backbone.core.ui.QAppNavigatorLabelProvider;
import eu.qimpress.ide.backbone.core.ui.QAppNavigatorContentProvider.ContentFilterEnum;

public abstract class AbstractQAlternativePage extends WizardPage {

	public enum SELECT_ALTERNATIVES {
		NONE, SELECT_ONE, SELECT_MULTIPLE
	}

	TreeViewer alternativeViewer;

	private IQAlternative parentAlternative;
	private SELECT_ALTERNATIVES selectAlternatives = SELECT_ALTERNATIVES.NONE;

	private List<IQAlternative> selectedAlternatives = null;

	protected AbstractQAlternativePage(IQAlternative parentAlternative,
			String pageName, SELECT_ALTERNATIVES selectAlternatives) {
		super(pageName);
		this.parentAlternative = parentAlternative;
		this.selectAlternatives = selectAlternatives;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets
	 * .Composite)
	 */
	@Override
	public void createControl(Composite parent) {
		final Composite composite = new Composite(parent, SWT.NULL);

		initializeDialogUnits(parent);
		composite.setLayout(new GridLayout(4, false));

		setControl(composite);

		// Parent alternative label ...
		Label parentAlternativeLabel = new Label(composite, SWT.NONE);
		parentAlternativeLabel.setText("Parent alternative");
		GridDataFactory.generate(parentAlternativeLabel, 1, 1);

		// Alternative tree viewer
		if (selectAlternatives == SELECT_ALTERNATIVES.NONE) {
			alternativeViewer = new TreeViewer(
					composite,
					SWT.SINGLE | SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER | SWT.VIRTUAL);
		} else {
			alternativeViewer = new CheckboxTreeViewer(
					composite,
					SWT.SINGLE | SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER | SWT.VIRTUAL);
			// When user checks a checkbox in the tree, check all its children
			((CheckboxTreeViewer) alternativeViewer).addCheckStateListener(new ICheckStateListener() {
				public void checkStateChanged(CheckStateChangedEvent event) {
					if (selectAlternatives == SELECT_ALTERNATIVES.SELECT_MULTIPLE) {
						// If the item is checked...
						if (event.getChecked()) {
							// check all its children
							((CheckboxTreeViewer) alternativeViewer).setSubtreeChecked(event.getElement(), true);
						}
						selectedAlternatives = new ArrayList<IQAlternative>();
						Object[] checkedElements = ((CheckboxTreeViewer) alternativeViewer).getCheckedElements();
						for (int i = 0; i < ((CheckboxTreeViewer) alternativeViewer).getCheckedElements().length; i++) {
							if ((checkedElements[i]) instanceof IQAlternative) {
								selectedAlternatives.add((IQAlternative)checkedElements[i]);
							}
						}
					}
					if (selectAlternatives == SELECT_ALTERNATIVES.SELECT_ONE) {
						if (!(event.getElement() instanceof IQAlternative)) {
							if (event.getChecked()) {
								((CheckboxTreeViewer) alternativeViewer).setChecked(event.getElement(), false);
							}
						} else {
							if (event.getChecked() == false) {
								((CheckboxTreeViewer) alternativeViewer).setCheckedElements(new Object[]{});
								selectedAlternatives = new ArrayList<IQAlternative>();
							} else {
								((CheckboxTreeViewer) alternativeViewer).setCheckedElements(new Object[]{event.getElement()});
								selectedAlternatives = new ArrayList<IQAlternative>();
								selectedAlternatives.add((IQAlternative)event.getElement());
							}
						}
					}
				}
			});
		}
		alternativeViewer.setContentProvider(new QAppNavigatorContentProvider(
				ContentFilterEnum.FILTER_DEFAULT_ALTERNATIVE.val()));
		alternativeViewer.setLabelProvider(new QAppNavigatorLabelProvider());
		alternativeViewer.setInput(QImpressApplicationModelManager.getManager().getQAppModel());
		if (parentAlternative != null) {
			alternativeViewer.setSelection(new StructuredSelection(
					parentAlternative), true);
			alternativeViewer.expandToLevel(parentAlternative, TreeViewer.ALL_LEVELS);
			alternativeViewer.expandAll();
		}

		GridDataFactory.generate(alternativeViewer.getControl(), 3, 1);

	}

	/**
	 * Return reference to an parent alternative or null if the alternative
	 * shoudl be top-level.
	 * 
	 * @return
	 */
	public IStructuredSelection getAlternativeParentSelection() {
		ISelection selection = alternativeViewer.getSelection();

		if (selection instanceof IStructuredSelection && ((IStructuredSelection) selection).size() == 1) {
			return (IStructuredSelection) selection;
		}

		return null;
	}

	public abstract String getAlternativeName();

	protected boolean validatePage() {
		String altName = getAlternativeName();
		if (altName == null || altName.equals("")) {
			setErrorMessage("Alternative name cannot be null!");

			return false;
		}

		if (getAlternativeParentSelection() == null) {
			setErrorMessage("Parent alternative or alternative repository/project has to be selected!");
		}

		return true;
	}

}
