/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.widgets;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import eu.qimpress.ide.backbone.core.model.IQAlternative;

/**
 * Q-Impress specific tree viewer. 
 * 
 * @author Michal Malohlava
 *
 */
public class QAlternativesTreeViewer extends TreeViewer {
	
//	private static final String EXTENSION_ID = QAlternativesTreeViewer.class.getCanonicalName();

	protected QAlternativesTreeViewer(Composite aParent) {
		this(aParent, SWT.SINGLE | SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER | SWT.VIRTUAL );
	}
	
	public QAlternativesTreeViewer(Composite aParent, int aStyle) {
		super(aParent, aStyle);
	}
	
	public IQAlternative getFirstSelectedAlternative() {
		ISelection selection = getSelection();
		
		if (selection instanceof IStructuredSelection) {
			Object o = ((IStructuredSelection) selection).getFirstElement();
			if (o instanceof IQAlternative) {
				return (IQAlternative) o;
			}
		}
		
		return null;
	}
}
