/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.tabs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativesTreeViewerFactory;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativesTreeViewerFactory.SelectAlternativesEnum;

/**
 * @author Steffen Becker
 *
 */
public class QImpressAlternativeUsageScenarioSelectionTab 
extends	QImpressAlternativeSelectionTab {
	
	public static final String SELECTED_ALTERNATIVE_GUID = "eu.qimpress.reverseengineering.alternativeselection";
	private CheckboxTreeViewer myAlternativesViewer;
	private Label selectionText;

	/**
	 * @wbp.parser.entryPoint
	 */
	@Override
	public void createControl(Composite parent) {
		super.createControl(parent);
			
	}


	@Override
	public void initializeFrom(ILaunchConfiguration configuration) {
		String guid = "";
		try {
			guid = configuration.getAttribute(SELECTED_ALTERNATIVE_GUID, "");
		} catch (CoreException e) { }
		
		if (!guid.equals("")) {
			IQApplicationModel model = (IQApplicationModel) myAlternativesViewer.getInput();
			IQElement alternative = model.getElementByID(guid);
			if (alternative != null) {
				myAlternativesViewer.expandAll();
				myAlternativesViewer.setChecked(alternative, true);
			}
			//model.get
		}
	}

	@Override
	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		Object[] elements = myAlternativesViewer.getCheckedElements();
		if (elements.length != 1 || !(elements[0] instanceof IQAlternative)) {
			configuration.setAttribute(SELECTED_ALTERNATIVE_GUID, "");
		} else {
			IQAlternative selectedAlternative = (IQAlternative) elements[0];
			configuration.setAttribute(SELECTED_ALTERNATIVE_GUID, selectedAlternative.getInfo().getId());
		}
	}

	
	@Override
	public boolean isValid(ILaunchConfiguration launchConfig) {
		if (!super.isValid(launchConfig)) return false;
		
		return getErrorMessage() == null;
	}

	
	@Override
	public String getErrorMessage() {
		Object[] elements = myAlternativesViewer.getCheckedElements();
		if (elements.length != 1) return "Select a single alternative";
		if (!(elements[0] instanceof IQAlternative)) return "Selection is not an alternative";
		
		//IQAlternative selectedAlternative = (IQAlternative) elements[0];
		// if (selectedAlternative. ... )
		
		return null;
	}

	@Override
	public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
		configuration.setAttribute(SELECTED_ALTERNATIVE_GUID, "");
	}
}
