/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.tabs;

import java.util.Enumeration;
import java.util.Vector;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativesTreeViewerFactory;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativesTreeViewerFactory.SelectAlternativesEnum;

/**
 * @author Steffen Becker
 *
 */
public class QImpressAlternativeSelectionTab 
extends	AbstractLaunchConfigurationTab {
	
	public static final String SELECTED_ALTERNATIVE_GUID = "eu.qimpress.reverseengineering.alternativeselection";
	private CheckboxTreeViewer myAlternativesViewer;
	private Label selectionText;
	
	public QImpressAlternativeSelectionTab() {
		alternativeListeners = new Vector<AlternativeSelectionListener>();
	}

	/**
	 * @wbp.parser.entryPoint
	 */
	@Override
	public void createControl(Composite parent) {
		Composite myTabControl = new Composite(parent,SWT.NONE);
		GridLayout gridLayout = new GridLayout();
		gridLayout.marginWidth = 5;
		gridLayout.marginHeight = 5;
		gridLayout.numColumns = 2;
		myTabControl.setLayout(gridLayout);
		setControl(myTabControl);
		
		Group grpSelectQimpressAlternative = new Group(myTabControl, SWT.FILL);
		grpSelectQimpressAlternative.setText("Select Q-ImPrESS Alternative");
		FillLayout fillLayout = new FillLayout(SWT.HORIZONTAL);
		fillLayout.marginWidth = 5;
		fillLayout.marginHeight = 5;
		grpSelectQimpressAlternative.setLayout(fillLayout);
		grpSelectQimpressAlternative.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true,2,1));
			
		myAlternativesViewer = (CheckboxTreeViewer) QAlternativesTreeViewerFactory.createTreeViewer(grpSelectQimpressAlternative, SelectAlternativesEnum.SELECT_ONE).getTreeViewer();
		myAlternativesViewer.addCheckStateListener(new ICheckStateListener() {
			
			public void checkStateChanged(CheckStateChangedEvent event) {
				if (event.getElement() instanceof IQAlternative) {
					if (event.getChecked()) {
						IQAlternative alt =  (IQAlternative) event.getElement();
						selectionText.setText(alt.getInfo().getDescription());
						fireAlternativeSelected(alt);
					} else {
						selectionText.setText("<none>");
						fireAlternativeSelected(null);
					}
					
					setDirty(true);
					updateLaunchConfigurationDialog();
				} 
			}
		});
		myAlternativesViewer.expandAll();
		
		Label selection = new Label(myTabControl,SWT.NONE);
		selection.setText("Selected Top-Level Alternative: ");
		selection.setLayoutData(new GridData(SWT.FILL,SWT.FILL,false,false,1,1));
		
		selectionText = new Label(myTabControl,SWT.NONE);
		selectionText.setText("<none>");
		selectionText.setLayoutData(new GridData(SWT.FILL,SWT.FILL,false,false,1,1));
		
	}

	@Override
	public String getName() {
		return "QImPrESS Alternative";
	}

	@Override
	public void initializeFrom(ILaunchConfiguration configuration) {
		String guid = "";
		try {
			guid = configuration.getAttribute(SELECTED_ALTERNATIVE_GUID, "");
		} catch (CoreException e) { }
		
		if (!guid.equals("")) {
			IQApplicationModel model = (IQApplicationModel) myAlternativesViewer.getInput();
			IQElement alternative = model.getElementByID(guid);
			if (alternative != null) {
				myAlternativesViewer.expandAll();
				myAlternativesViewer.setChecked(alternative, true);
				
				fireAlternativeSelected((IQAlternative) alternative);
			}
		}
	}

	@Override
	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		Object[] elements = myAlternativesViewer.getCheckedElements();
		if (elements.length != 1 || !(elements[0] instanceof IQAlternative)) {
			configuration.setAttribute(SELECTED_ALTERNATIVE_GUID, "");
		} else {
			IQAlternative selectedAlternative = (IQAlternative) elements[0];
			configuration.setAttribute(SELECTED_ALTERNATIVE_GUID, selectedAlternative.getInfo().getId());
		}
	}

	
	@Override
	public boolean isValid(ILaunchConfiguration launchConfig) {
		if (!super.isValid(launchConfig)) return false;
		
		return getErrorMessage() == null;
	}

	
	@Override
	public String getErrorMessage() {
		Object[] elements = myAlternativesViewer.getCheckedElements();
		if (elements.length != 1) return "Select a single alternative";
		if (!(elements[0] instanceof IQAlternative)) return "Selection is not an alternative";
		
		//IQAlternative selectedAlternative = (IQAlternative) elements[0];
		// if (selectedAlternative. ... )
		
		return null;
	}

	@Override
	public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
		configuration.setAttribute(SELECTED_ALTERNATIVE_GUID, "");
	}
	
	// Public available listener for the selected alternative.
	private transient Vector<AlternativeSelectionListener> alternativeListeners;

	public void addAlternativeSelectionListener(AlternativeSelectionListener listener) {
		alternativeListeners.addElement(listener);
	}

	public void removeAlternativeSelectionListener(AlternativeSelectionListener listener) {
		alternativeListeners.removeElement(listener);
	}
	
	/** Fire to all registered listeners */
	@SuppressWarnings("unchecked")
	protected void fireAlternativeSelected(IQAlternative alternative) {
		// If we have no listeners, do nothing.
		if ((alternativeListeners != null) && !alternativeListeners.isEmpty()) {
			// Make a copy of the listener list in case anyone adds or removes
			// listeners.
			Vector<AlternativeSelectionListener> targets;
			synchronized (alternativeListeners) {
				targets = (Vector<AlternativeSelectionListener>) alternativeListeners.clone();
			}

			// Walk through the listener list and call the listener method in
			// each.
			Enumeration<AlternativeSelectionListener> e = targets.elements();
			while (e.hasMoreElements()) {
				AlternativeSelectionListener l = (AlternativeSelectionListener) e.nextElement();
				l.alternativeSelected(alternative);
			}
		}
	}
}
