package eu.qimpress.ide.backbone.core.ui.perspectives;

import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.navigator.resources.ProjectExplorer;

import eu.qimpress.ide.backbone.core.ui.wizards.NewQAlternativeWizard;
import eu.qimpress.ide.backbone.core.ui.wizards.QImPrESSNewProjectWizard;

/**
 * Q-ImPrESS perspective implementation.
 */
public class QIPerspective implements IPerspectiveFactory {
	

	/** The ID of this GUI element. */
	public static final String PERSPECTIVE_ID = "eu.qimpress.ide.perspective.QIPerspectiveID";

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.IPerspectiveFactory#createInitialLayout(org.eclipse.ui.IPageLayout)
	 */
	@Override
	public void createInitialLayout(IPageLayout layout) {
		addViews(layout);
		addActionSets(layout);
		addNewWizardShortcuts(layout);
		addPerspectiveShortcuts(layout);
		addViewShortcuts(layout);
	}

	/**
	 * Adds the views.
	 */
	private void addViews(IPageLayout layout) {
		// create left panel view area
		IFolderLayout left = layout.createFolder("left", IPageLayout.LEFT, 0.25f, layout.getEditorArea());
		left.addView(ProjectExplorer.VIEW_ID);
		left.addView(IPageLayout.ID_RES_NAV);
		
		// create bottom panel view area
		IFolderLayout bottom = layout.createFolder("bottom", IPageLayout.BOTTOM, 0.75f, layout.getEditorArea());
		bottom.addView(IPageLayout.ID_PROP_SHEET);
		bottom.addView(IPageLayout.ID_PROBLEM_VIEW);
		bottom.addView(IConsoleConstants.ID_CONSOLE_VIEW);
		
		// create right panel view area
		IFolderLayout right = layout.createFolder("right", IPageLayout.RIGHT, 0.75f, layout.getEditorArea());
		right.addView(IPageLayout.ID_OUTLINE);
		bottom.addPlaceholder(IConsoleConstants.ID_CONSOLE_VIEW);
		
	}

	/**
	 * Adds the action sets.
	 */
	private void addActionSets(IPageLayout layout) {
		layout.addActionSet(IDebugUIConstants.LAUNCH_ACTION_SET);
	}

	/**
	 * Adds the perspective shortcuts.
	 */
	private void addPerspectiveShortcuts(IPageLayout layout) {
		layout.addPerspectiveShortcut(PERSPECTIVE_ID);
	}

	/**
	 * Adds the new wizard shortcuts.
	 */
	private void addNewWizardShortcuts(IPageLayout layout) {
		layout.addNewWizardShortcut(QImPrESSNewProjectWizard.WIZARD_ID);
		
		layout.addNewWizardShortcut(NewQAlternativeWizard.WIZARD_ID);
		
		// TODO put here shortcuts to create models
	}

	/**
	 * Adds the view shortcuts.
	 */
	private void addViewShortcuts(IPageLayout layout) {		
		layout.addShowViewShortcut(IConsoleConstants.ID_CONSOLE_VIEW);
		
		// TODO put here shortcuts of Q-I related views
	}

}
