/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.internal.properties;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

import eu.qimpress.ide.backbone.core.model.IQAlternativeInfo;
import eu.qimpress.ide.backbone.core.ui.internal.QAppElementAdapterFactory;

/**
 * Property source for {@link IQAlternativeInfo}.
 * 
 * It provides alternative ID, description, default state and date of creation. 
 * The property source is provided by {@link QAppElementAdapterFactory}.
 * 
 * @author Michal Malohlava
 * 
 * @see QAppElementAdapterFactory
 * @see IQAlternativeInfo
 *
 */
public class QAlternativeInfoPropertySource implements IPropertySource {
	
	private IQAlternativeInfo altInfo;

	/* constants of published attributes */
	private static final String ALTERNATIVE_INFO_ID = "alternative.info.id";	
	private static final String ALTERNATIVE_INFO_DESC = "alternative.info.desc";
	private static final String ALTERNATIVE_INFO_DEFAULT = "alternative.info.default";
	private static final String ALTERNATIVE_INFO_CREATION = "alternative.info.creation";
	
	static private IPropertyDescriptor[] propertyDescriptors = new IPropertyDescriptor[4];
	
	static {
		PropertyDescriptor desc;
		
		desc = new PropertyDescriptor(ALTERNATIVE_INFO_ID, "ID");
		propertyDescriptors[0] = desc;
						
		desc = new PropertyDescriptor(ALTERNATIVE_INFO_DESC, "Description");
		propertyDescriptors[1] = desc;
		
		desc = new PropertyDescriptor(ALTERNATIVE_INFO_DEFAULT, "Is default");
		propertyDescriptors[2] = desc;
		
		desc = new PropertyDescriptor(ALTERNATIVE_INFO_CREATION, "Creation date");
		propertyDescriptors[3] = desc;		
	}
	
	public QAlternativeInfoPropertySource(IQAlternativeInfo altInfo) {
		this.altInfo = altInfo;				
	}

	@Override
	public Object getEditableValue() {		
		return this.altInfo;
	}

	@Override
	public IPropertyDescriptor[] getPropertyDescriptors() {		
		return propertyDescriptors;
	}

	@Override
	public Object getPropertyValue(Object id) {		
		if (id.equals(ALTERNATIVE_INFO_ID)) {
			return altInfo.getId();
		} else if (id.equals(ALTERNATIVE_INFO_DESC)) {
			return altInfo.getDescription();			
		} else if (id.equals(ALTERNATIVE_INFO_DEFAULT)) {
			return altInfo.isDefault();			
		} else if (id.equals(ALTERNATIVE_INFO_CREATION)) {
			return altInfo.getCreationDate();			
		}
		
		return null;
	}

	@Override
	public boolean isPropertySet(Object id) {		
		return true;
	}

	@Override
	public void resetPropertyValue(Object id) {
	}

	@Override
	public void setPropertyValue(Object id, Object value) {
	}

}
