/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.internal.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.TreePath;

import eu.qimpress.ide.backbone.core.model.IQAlternative;

/**
 * Simple Q-Impress filter representation.
 * 
 * @author Michal Malohlava
 *
 */
public class QFilter implements IQFilter {
	
	String name;
	String pattern;
	boolean global;
	Pattern compiledPattern;

	public QFilter(String name, String pattern, boolean global) {
		super();
		this.name = name;
		this.pattern = pattern;
		this.global = global;
		
		this.compiledPattern = Pattern.compile(this.pattern);
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public String getPattern() {
		return pattern;
	}

	@Override
	public boolean isGlobal() {
		return global;
	}

	@Override
	public boolean select(Object parent, Object element) {
		if (!isGlobal() && parent instanceof TreePath) {
			TreePath tpath = (TreePath) parent;
			if (!(tpath.getLastSegment() instanceof IQAlternative)) {
				return true;
			}
		}
		
		IResource resource = getResource(element); 
		if (resource != null) {			
			Matcher matcher = compiledPattern.matcher(resource.getName());
			return !matcher.matches();			
		}
		
		return true;
	}

	private IResource getResource(Object element) {
		if (element instanceof IResource) {
			return (IResource) element;
		} else if (element instanceof IAdaptable) {
			return (IResource) ((IAdaptable) element).getAdapter(IResource.class);
		}
		
		return null;
	}

}
