/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.internal.filters;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

/**
 * Generic content filter filtering content according to registered 
 * resources via extension point (see ext. point <code>eu.qimpress.ide.backbone.core.ui.filters</code>).
 * 
 * @author Michal Malohlava 
 */
public class GenericHiddenContentFilter extends ViewerFilter {
	
	public static final String QFILTERS_EXTENSION_POINT_ID = "eu.qimpress.ide.backbone.core.ui.filters";
	
	private IQFilter[] registeredFilters;

	/**
	 * Constructor. 
	 */
	public GenericHiddenContentFilter() {
		init();
	}
	
	protected void init() {
		IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(QFILTERS_EXTENSION_POINT_ID);
		
		registeredFilters = new IQFilter[configs.length];
		int i = 0;
		for (IConfigurationElement config : configs) {
			registeredFilters[i++] = createFilter(config);
		}
	}
	
	protected IQFilter createFilter(IConfigurationElement config) {
		IQFilter filter = new QFilter(
				config.getAttribute("name"), 
				config.getAttribute("pattern"), 
				Boolean.getBoolean(config.getAttribute("global-scope")));
		 
		return filter;		 		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ViewerFilter#select(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	@Override
	public boolean select(Viewer viewer, Object parentElement, Object element) {
		for (IQFilter filter : registeredFilters) {
			return filter.select(parentElement, element);			
		}
		
		return true;
	}

}
