/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.internal;


import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.ide.IContributorResourceAdapter2;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.IPropertySource;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.QElementResourceMapping;
import eu.qimpress.ide.backbone.core.model.IQElement.ElementType;
import eu.qimpress.ide.backbone.core.ui.internal.properties.QAlternativeInfoPropertySource;

/**
 * Core adapter factory for {@link IQElement}.
 *  
 * @author Michal Malohlava
 *
 */
public class QAppElementAdapterFactory implements IAdapterFactory, IContributorResourceAdapter, IContributorResourceAdapter2 {
	
	@SuppressWarnings("unchecked")
	private static final Class[] SUPPORTED_ADAPTERS = new Class[] {
		IResource.class,
		IWorkbenchAdapter.class,
		IContributorResourceAdapter.class,
		IContributorResourceAdapter2.class,
		IWorkbenchAdapter.class,
		IPropertySource.class
	};
	
	private QAppWorkbenchAdapter qAppWorkbenchAdapter; 

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Object adaptableObject, Class adapterType) {
		IQElement element = getQAppElement(adaptableObject);		
		
		if (IResource.class.equals(adapterType)) {
			return getResource(element);
		} else if (IContributorResourceAdapter.class.equals(adapterType)) {
			return this;
		} else if (IContributorResourceAdapter2.class.equals(adapterType)) {
			return this;
		} else if (IWorkbenchAdapter.class.equals(adapterType)) {
			return getQAppWorkbenchAdaper();
		} else if (IPropertySource.class.equals(adapterType)) {
			return getPropertySource(element);
		}
		
		return null;
	}

	private IPropertySource getPropertySource(IQElement element) {
		
		if (element.getElementType() == ElementType.Q_ALTERNATIVE) {
			return new QAlternativeInfoPropertySource(((IQAlternative) element).getInfo());
		}
		
		return null;
	}

	private IWorkbenchAdapter getQAppWorkbenchAdaper() {
		if (this.qAppWorkbenchAdapter == null) {
			this.qAppWorkbenchAdapter = new QAppWorkbenchAdapter(); 
		}
		
		return this.qAppWorkbenchAdapter; 
	}

	private IResource getResource(IQElement element) {		
		return element.getCorrespondingResource();
	}

	private IQElement getQAppElement(Object adaptableObject) {
		if (adaptableObject instanceof IQElement) {
			return (IQElement) adaptableObject;
		}
		return null;
	}

	@SuppressWarnings("unchecked")
	@Override
	public Class[] getAdapterList() {		
		return SUPPORTED_ADAPTERS;
	}

	@Override
	public IResource getAdaptedResource(IAdaptable adaptable) {
		IQElement element = getQAppElement(adaptable);
		if (element != null) {
			return getResource(element);
		}
		return null;		
	}

	@Override
	public ResourceMapping getAdaptedResourceMapping(IAdaptable adaptable) {
		IQElement element = getQAppElement(adaptable);
		if (element != null) {
			return QElementResourceMapping.create(element);
		}
		return null;
	}

}
