/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.decorators;

import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.model.IQAlternative;

/**
 * @author Michal Malohlava
 *
 */
public class AlternativeDecorator extends LabelProvider implements ILightweightLabelDecorator {
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILightweightLabelDecorator#decorate(java.lang.Object, org.eclipse.jface.viewers.IDecoration)
	 */
	@Override
	public void decorate(Object element, IDecoration decoration) {
		if (element instanceof IQAlternative) {			
			IQAlternative alternative = (IQAlternative) element;
			if (!QImpressCore.isGlobalAlternative(alternative)) {
				String id = " [" + alternative.getInfo().getId() + "]";
				
				decoration.addSuffix(id);
			}
		}
	}
}
