package eu.qimpress.ide.backbone.core.ui.actions;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

import eu.qimpress.ide.backbone.core.QImpressNature;
import eu.qimpress.ide.backbone.core.operations.InitializeQImpressProjectOperation;
import eu.qimpress.ide.backbone.core.utils.ProjectUtils;

public class ToggleQImpressNatureAction implements IObjectActionDelegate {
	
	private static final Logger logger = Logger.getLogger(ToggleQImpressNatureAction.class);

	private IProject project;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		if (project != null) {
			try {
				logger.trace("Toggle Q-ImPrESS nature for project: " + project);
				
				if (!QImpressNature.hasThisNature(project)) {
					// initialize project structure
					new InitializeQImpressProjectOperation(project).run(new NullProgressMonitor());
				}

				// toggle Q-I nature
				ProjectUtils.toggleNature(project);

			} catch (Exception e) {
				logger.error("Cannot toggle Q-ImPrESS nature for project: " + project, e);
				MessageDialog.openError(Display.getDefault().getActiveShell(), "Toggle Q-ImPrESS nature", "Cannot toggle Q-ImPrESS nature! See error log for details.");						
			}
		}				
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		this.project = null;
		
		if (selection instanceof IStructuredSelection
				&& !((IStructuredSelection) selection).isEmpty()) {
			Object element = ((IStructuredSelection) selection).getFirstElement();
			if (element instanceof IProject) {
				this.project = (IProject) element;
			} else if (element instanceof IAdaptable) {
				this.project = (IProject) ((IAdaptable) element).getAdapter(IProject.class);				
			}
		}
		
		if (this.project != null) {
			try {
				if (project.hasNature(QImpressNature.NATURE_ID)) {
					action.setText("Disable Q-ImPrESS nature");				
				} else {
					action.setText("Enable Q-ImPrESS nature");
				}
			} catch (CoreException e) {
				action.setText("Enable/Disable Q-ImPrESS nature");
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IObjectActionDelegate#setActivePart(org.eclipse.jface.action.IAction,
	 *      org.eclipse.ui.IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}
}
