/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQElement.ElementType;
import eu.qimpress.ide.backbone.core.ui.internal.QImpressUICorePluginImages;
import eu.qimpress.ide.backbone.core.ui.wizards.NewQAlternativeWizard;

/**
 * @author Michal Malohlava
 *
 */
public class OpenNewAlternativeWizardAction extends QElementSelectionDispatchAction {
		
	public OpenNewAlternativeWizardAction(IWorkbenchSite site) {
		this(site, null);		
	}
	
	public OpenNewAlternativeWizardAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget) {
		super(site, selectionTarget);
		
		setText("New alternative");
		setDescription("Create new alternative");
		setImageDescriptor(QImpressUICorePluginImages.DESC_ALTERNATIVE);
	}
	
	@Override
	public void run() {
		Shell shell= getShell();
		
		try {
			INewWizard wizard= createWizard();
			wizard.init(PlatformUI.getWorkbench(), getSelection());

			WizardDialog dialog= new WizardDialog(shell, wizard);
			PixelConverter converter= new PixelConverter(JFaceResources.getDialogFont());
			dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
			dialog.create();
			int res= dialog.open();
			notifyResult(res == Window.OK);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	protected INewWizard createWizard() {
		return new NewQAlternativeWizard();
	}
	
	@Override
	protected void postSelectionChanged(IQElement[] elements) {
		if (elements.length == 1 && elements[0].getElementType() == ElementType.Q_ALTERNATIVE && !( ( (IQAlternative) elements[0]).getParent() instanceof IQProject) ) {
			setEnabled(true);
		} else {		
			setEnabled(false);
		}
	}
}
