/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQElement.ElementType;

/**
 * This action open the selected model in a default editor (e.g. - EMF tree-based editor)  
 * 
 * @author Michal Malohlava
 *
 */
public class ModelDefaultOpenAction extends QElementSelectionDispatchAction {

	private static final Logger logger = Logger.getLogger(ModelDefaultOpenAction.class);
	
	public ModelDefaultOpenAction(IWorkbenchSite site) {
		super(site);
		setText("Open");
		setDescription("Open model default editor");
		setToolTipText("Open model default editor");				
	}

	@Override
	protected void runInternal(IQModel[] models) {
		
		if (models.length != 1) 
			return;
		
		IQModel model = models[0];
		try {
			IFile modelFile = (IFile) model.getCorrespondingResource();
			
			IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
			IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(modelFile.getName());
			
			if (desc != null) {
				page.openEditor(new FileEditorInput(modelFile), desc.getId());
			} else {
				logger.warn("Cannot open default editor for selected entity");				
			}
		} catch (PartInitException e) {
			logger.warn("Cannot open default editor for selected entity", e);				
		} 		
	}
	
	@Override
	protected void postSelectionChanged(IQElement[] elements) {		
		if (elements.length == 1 && elements[0].getElementType() == ElementType.Q_MODEL) {
			setEnabled(true);			
		} else {
			setEnabled(false);
		}
	}
}
