/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ISetSelectionTarget;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.ISaveable;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.model.IQElement.ElementType;
import eu.qimpress.ide.backbone.core.ui.internal.QImpressUICorePluginImages;

/**
 * Make current alternative default.
 * 
 * @author Michal Malohlava
 *
 */
public class MakeAlternativeDefaultAction extends QElementSelectionDispatchAction {

	public MakeAlternativeDefaultAction(IWorkbenchSite site) {
		this(site, null);
	}
	
	public MakeAlternativeDefaultAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget) {
		super(site, selectionTarget);
		setText("Make alternative default");
		setDescription("Make selected alternative default");
		setImageDescriptor(QImpressUICorePluginImages.DESC_DEFAULT_ALTERNATIVE);
	}

	@Override
	protected void runInternal(IQAlternative[] alternatives) {
		if (alternatives.length != 1)
			return;
		
		IQAlternative alternative = alternatives[0];
		
		if (!alternative.getInfo().isDefault()) {
			IQRepository repo = alternative.getRepository();
			
			try {
				IQAlternative defaultAlternative = repo.getDefaultAlternative(); 
				
				alternative.getInfo().setDefault(true);
				defaultAlternative.getInfo().setDefault(false);			
				
				saveAlternative(alternative);
				saveAlternative(defaultAlternative);
				
				QImpressApplicationModelManager.getManager().getQAppModel().fireRefresh();
			} catch (RepositoryException e) {
				reportError("Cannot make given alternative default!", e);
			}
		}
	}
	
	private void saveAlternative(IQAlternative alt) throws RepositoryException {
		if (alt instanceof ISaveable) {
			((ISaveable) alt).save();
		}
	}
	
	@Override
	protected void postSelectionChanged(IQElement[] elements) {
		if (elements.length == 1 && elements[0].getElementType() == ElementType.Q_ALTERNATIVE && !((IQAlternative) elements[0]).getInfo().isDefault()) {
			setEnabled(true);			
		} else {
			setEnabled(false);
		}
	}

}
