/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ISetSelectionTarget;

import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.model.IQElement.ElementType;

/**
 * @author Petr Hnetynka
 *
 */
public class DeleteModelAction extends QElementSelectionDispatchAction {

	public DeleteModelAction(IWorkbenchSite site) {
		this(site, null);
	}
	
	public DeleteModelAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget) {
		super(site, selectionTarget);
		setText("Delete Model");
		setDescription("Delete selected model");
		setToolTipText("Deletes selected model.");
		setImageDescriptor(eu.qimpress.ide.backbone.core.ui.internal.QImpressUICorePluginImages.DESC_RED_DELETE);
	}
	
	@Override
	protected void runInternal(IQModel[] models) {
				
		if (canDelete(models)) {
			try {	
				unselect();
				
				for (IQModel model : models) {
					model.delete();
				}
				
				QImpressApplicationModelManager.getManager().getQAppModel().fireRefresh();
				
			} catch (RepositoryException ex) {
				MessageDialog.openError(getShell(), "Delete model", "Cannot delete model");
				// FIXME add reporting the exception
				return;
			}
			MessageDialog.openInformation(getShell(), "Delete model", "Successfully deleted.");			
		}
	}
	
	private boolean canDelete(IQModel[] models) {
		if (models.length == 1)
			return MessageDialog.openQuestion(getShell(), "Delete model", "Do you want really delete the model " + models[0].getName() + "?");
		else 
			return MessageDialog.openQuestion(getShell(), "Delete models", "Do you want really delete the selected models?");
	}
	
	@Override
	protected void postSelectionChanged(IQElement[] elements) {		
		if (elements.length > 0 && elements[0].getElementType() == ElementType.Q_MODEL) {
			setEnabled(true);			
		} else {
			setEnabled(false);
		}
	}

}
