/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.model.IQElement.ElementType;

/**
 * @author Michal Malohlava
 *
 */
public class DeleteAlternativeAction extends QElementSelectionDispatchAction {

	public DeleteAlternativeAction(IWorkbenchSite site) {
		super(site);
		setText("Delete alternative");
		setDescription("Delete selected alternative");
		setToolTipText("Deletes selected alternative with no children. Does not delete models in the alternative.");
		setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_TOOL_DELETE));
	}
	
	@Override
	protected void runInternal(IQAlternative[] alternatives) {
		if (canDelete(alternatives)) {
			try {
				for (IQAlternative alternative  : alternatives) {
					alternative.getRepository().deleteAlternative(alternative);
				}
				
				QImpressApplicationModelManager.getManager().getQAppModel().fireRefresh();
			} catch (RepositoryException ex) {
				MessageDialog.openError(getShell(), "Delete alternative", "Cannot delete alternative");
				// FIXME add reporting the exception
				return;
			}
			MessageDialog.openInformation(getShell(), "Delete alternative", "Successfully deleted.");			
		}
	}
	
	private boolean canDelete(IQAlternative[] alternatives) {
		try {
			for (IQAlternative alternative : alternatives) {
				IQAlternative[] children = alternative.getRepository().getChildren(alternative);
				if (children.length != 0) {
					MessageDialog.openError(getShell(), "Delete alternative", "Cannot delete - there are child alternatives.");
					return false;
				}
			}
		} catch (RepositoryException ex) {
			MessageDialog.openError(getShell(), "Delete alternative", "Cannot obtain info about child alternatives");
			// FIXME add reporting the exception
			return false;
		}
		
		if (alternatives.length == 1)
			return MessageDialog.openQuestion(getShell(), "Delete alternative", "Do you want really delete alternative: " + alternatives[0].getInfo().getDescription() + "?");
		else 
			return MessageDialog.openQuestion(getShell(), "Delete alternative", "Do you want really delete selecetd alternatives?");
		
	}
	
	@Override
	protected void postSelectionChanged(IQElement[] elements) {		
		if (elements.length > 0 && elements[0].getElementType() == ElementType.Q_ALTERNATIVE) {
			setEnabled(true);			
		} else {
			setEnabled(false);
		}
	}

}
