/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbenchSite;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.model.IQElement.ElementType;

/**
 * @author Petr Hnetynka
 *
 */
public class CompleteDeleteAlternativeAction extends QElementSelectionDispatchAction {

	public CompleteDeleteAlternativeAction(IWorkbenchSite site) {
		super(site);
		setText("Completly delete alternative");
		setDescription("Delete selected alternative with child alternatives recursively");
		setToolTipText("Deletes selected alternative with child alternatives recursively. Deletes also models in the alternatives.");
		setImageDescriptor(eu.qimpress.ide.backbone.core.ui.internal.QImpressUICorePluginImages.DESC_RED_DELETE);
	}
	
	@Override
	protected void runInternal(IQAlternative[] alternatives) {
				
		if (canDelete(alternatives)) {
			try {
				for (IQAlternative alternative : alternatives) {
					alternative.getRepository().deleteAlternative(alternative, true, true);
				}
				
				QImpressApplicationModelManager.getManager().getQAppModel().fireRefresh();
			} catch (RepositoryException ex) {
				MessageDialog.openError(getShell(), "Delete alternative", "Cannot delete alternative");
				// FIXME add reporting the exception
				return;
			}
			MessageDialog.openInformation(getShell(), "Delete alternative", "Successfully deleted.");			
		}
	}
	
	private boolean canDelete(IQAlternative[] alternatives) {
		if (alternatives.length == 1)
			return MessageDialog.openQuestion(getShell(), "Delete alternative", "Do you want really delete the alternative " + alternatives[0].getInfo().getDescription() + " with all its child alternatives?");
		else 
			return MessageDialog.openQuestion(getShell(), "Delete alternative", "Do you want really delete the alternative selected alternatives with all its child alternatives?");		
	}
	
	@Override
	protected void postSelectionChanged(IQElement[] elements) {		
		if (elements.length > 0 && elements[0].getElementType() == ElementType.Q_ALTERNATIVE) {
			setEnabled(true);			
		} else {
			setEnabled(false);
		}
	}

}
