/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

import eu.qimpress.ide.backbone.core.ui.actions.AlternativesActionGroup;
import eu.qimpress.ide.backbone.core.ui.actions.ModelsActionGroup;

/**
 * Contribute alternatives manipulation action into action pop-up menu.
 *  
 * @author Michal Malohlava
 *
 */
public class QAppNavigatorActionProvider extends CommonActionProvider {

	private AlternativesActionGroup alternativesActionGroup;
	private ModelsActionGroup modelsActionGroup;
		
	private boolean inViewPart = false;
		
	@Override
	public void init(ICommonActionExtensionSite aSite) {		
		super.init(aSite);
		
		ICommonViewerWorkbenchSite workbenchSite= null;
		if (aSite.getViewSite() instanceof ICommonViewerWorkbenchSite)
			workbenchSite = (ICommonViewerWorkbenchSite) aSite.getViewSite();

		if (workbenchSite != null) {
			if (workbenchSite.getPart() != null && workbenchSite.getPart() instanceof IViewPart) {
				IViewPart viewPart = (IViewPart) workbenchSite.getPart();
				
				this.alternativesActionGroup = new AlternativesActionGroup(viewPart, aSite.getStructuredViewer());
				this.modelsActionGroup = new ModelsActionGroup(viewPart, aSite.getStructuredViewer());
				this.inViewPart = true;				
			}
		}
	}
	
	@Override
	public void fillActionBars(IActionBars actionBars) {
		if (inViewPart) {
			alternativesActionGroup.fillActionBars(actionBars);
			modelsActionGroup.fillActionBars(actionBars);
		}
	}
	
	@Override
	public void fillContextMenu(IMenuManager menu) {
		if (inViewPart) {
			alternativesActionGroup.fillContextMenu(menu);			
			modelsActionGroup.fillContextMenu(menu);
		}
	}
	
	@Override
	public void setContext(ActionContext context) {		
		super.setContext(context);
		if (inViewPart) {
			alternativesActionGroup.setContext(context);
			modelsActionGroup.setContext(context);
		}
	}
	
	@Override
	public void dispose() {
		if (inViewPart) {
			alternativesActionGroup.dispose();
			modelsActionGroup.dispose();
		}
		super.dispose();		
	}

}
