/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.models.adapters;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.ui.models.ShadowModelEditor;

/**
 * Adaptor extending alternative by providing {@link ShadowModelEditor} managing manipulation with
 * alternative models.
 * 
 * @author Michal Malohlava
 * 
 *
 */
public class QModelEditorAdapterFactory implements IAdapterFactory {
	
	/** static map managing relation between alternative and shadow editors */
	private static Map<IQAlternative, ShadowModelEditor> modelEditorsMap = new HashMap<IQAlternative, ShadowModelEditor>();
	
	private IPropertySourceProvider propertySourceProvider = new AdapterFactoryContentProvider(QModelsComposedAdapterFactoryProvider.getInstance().getAdapterFactory());
	
	@SuppressWarnings("unchecked")
	private static final Class[] SUPPORTED_ADAPTERS = new Class[] {		
		IEditingDomainProvider.class ,
		ShadowModelEditor.class,
		IPropertySource.class,
		Resource.class
		
	};

	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IAdapterFactory#getAdapter(java.lang.Object, java.lang.Class)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Object adaptableObject, Class adapterType) {		
		if (IEditingDomainProvider.class.equals(adapterType)) {
			return handleIEditingDomainProviderAdapter(adaptableObject);
		} else if (ShadowModelEditor.class.equals(adapterType)) {
			return handleShadowModelEditorAdapter(adaptableObject);
		} else if (IPropertySource.class.equals(adapterType)) {
			return handleIPropertySourceAdapter(adaptableObject);
		} else if (Resource.class.equals(adapterType)) {
			return handleEMFResourceAdapter(adaptableObject);
		}
		return null;
	}
	
	private Resource handleEMFResourceAdapter(Object adaptableObject) {
		Resource resource = null;
		
		if (adaptableObject instanceof IQModel) {
			IQModel qModel = (IQModel) adaptableObject;
									
			IQAlternative alternative = (IQAlternative) ((IQModel) adaptableObject).getParent();
			
			ShadowModelEditor shadowModelEditor = getEditor(alternative);
			
			if (!qModel.getCorrespondingResource().exists()) {
				resource = shadowModelEditor.createModelResource(qModel);
			} else {
				resource = shadowModelEditor.getModelResource(qModel);
			}			
		}
		
		return resource;
	}

	private Object handleIPropertySourceAdapter(Object adaptableObject) {
		if (adaptableObject instanceof EObject) {
			return propertySourceProvider.getPropertySource(adaptableObject);
		}

		return null;
	}

	protected Object handleShadowModelEditorAdapter(Object adaptableObject) {
		if (adaptableObject instanceof ShadowModelEditor) {
			return adaptableObject;
		} else if (adaptableObject instanceof IQAlternative){			
			return getEditor((IQAlternative) adaptableObject); 			
		} 
		
		return null;
	}

	protected Object handleIEditingDomainProviderAdapter(Object adaptableObject) {
		if (adaptableObject instanceof IEditingDomainProvider) {
			return adaptableObject;
		} else if (adaptableObject instanceof IQAlternative){			
			return getEditor((IQAlternative) adaptableObject); 			
		} 
		
		return null; 		
	}
	
	protected ShadowModelEditor getEditor(IQAlternative alternative) {
		ShadowModelEditor editor = null;
		if (modelEditorsMap.containsKey(alternative)) {
			editor = modelEditorsMap.get(alternative);
		} else {
			editor = new ShadowModelEditor(alternative);
			modelEditorsMap.put(alternative, editor);
			QImpressApplicationModelManager.getManager().getQAppModel().addChangeListener(editor);
		}
		return editor; 		
	}
	 

	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IAdapterFactory#getAdapterList()
	 */
	@SuppressWarnings("unchecked")
	@Override
	public Class[] getAdapterList() {
		return SUPPORTED_ADAPTERS;
	}

}
