/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.models.actions;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.navigator.ICommonMenuConstants;

/**
 * Based on generated EMF.Editor code - ActionBarContributor
 * 
 * @author Michal Malohlava
 *
 */
public class SammModelFamilyActionsGroup extends ActionGroup {
	
	// Show properties view action
	protected IAction showPropertiesViewAction =
		new Action("Show properties view") {
			@Override
			public void run() {
				try {
					activePart.getSite().getPage().showView("org.eclipse.ui.views.PropertySheet");
				}
				catch (PartInitException e) {					
					e.printStackTrace();
				}
			}
		};

	
	// global actions		
	protected DeleteAction deleteAction;
	protected UndoAction undoAction;
	protected RedoAction redoAction;
	
	private ISelectionProvider selectionProvider;
	private IWorkbenchPart activePart;
	
	private IMenuManager createChildMenuManager;
	private Collection<IAction> createChildActions;
	
	private IMenuManager createSiblingMenuManager;
	private Collection<IAction> createSiblingActions;
	
	public SammModelFamilyActionsGroup(IViewPart viewPart) {
		this(viewPart, null);
	}

	public SammModelFamilyActionsGroup(IViewPart viewPart, ISelectionProvider selectionProvider) {
		this.activePart = viewPart;
		this.selectionProvider = selectionProvider;		
		this.createChildMenuManager = new MenuManager("Create child");
		this.createSiblingMenuManager = new MenuManager("Create sibling"); 
				
		initActions();
	}
	
	private void initActions() {
		ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
		
		deleteAction = new DeleteAction(); 
	    deleteAction.setImageDescriptor(sharedImages.getImageDescriptor(ISharedImages.IMG_TOOL_DELETE));
	    
	    undoAction = new UndoAction();
	    undoAction.setImageDescriptor(sharedImages.getImageDescriptor(ISharedImages.IMG_TOOL_UNDO));
	    

	    redoAction = new RedoAction();
	    redoAction.setImageDescriptor(sharedImages.getImageDescriptor(ISharedImages.IMG_TOOL_REDO));	    
		
	}
	
	private void initMenus(IMenuManager menu) {
		menu.insertBefore(ICommonMenuConstants.GROUP_ADDITIONS, createChildMenuManager);		
		menu.insertBefore(ICommonMenuConstants.GROUP_ADDITIONS, createSiblingMenuManager);				
	}
	
	@Override
	public void fillActionBars(IActionBars actionBars) {
		super.fillActionBars(actionBars);
		
		shareGlobalActions(actionBars);
	}

	@Override
	public void fillContextMenu(IMenuManager menu) {		
		super.fillContextMenu(menu);
	
		ISelection selection = this.getContext().getSelection(); 
		if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
			Object object = ((IStructuredSelection)selection).getFirstElement();
			
			if (object instanceof EObject) {			
				// fill actions
				fillMenus(menu, (EObject) object, selection);				
			}
		}			
	}
	
	protected void fillMenus(IMenuManager menu, EObject selectedEntity, ISelection selection) {
		// add menus into the main menu
		initMenus(menu);

		Collection<?> newChildDescriptors = null;
		Collection<?> newSiblingDescriptors = null;
		EditingDomain domain = null;

//		domain = ((IEditingDomainProvider) Platform.getAdapterManager().getAdapter(selectedEntity, IEditingDomainProvider.class)).getEditingDomain();
		domain = ((IEditingDomainProvider) selectedEntity.eResource().getResourceSet()).getEditingDomain();

		newChildDescriptors = domain.getNewChildDescriptors(selectedEntity, null);
		newSiblingDescriptors = domain.getNewChildDescriptors(null, selectedEntity);

		// Generate actions for selection
		createChildActions = generateCreateChildActions(newChildDescriptors, selection);
		createSiblingActions = generateCreateSiblingActions(newSiblingDescriptors, selection);

		if (createChildMenuManager != null) {
			populateManager(createChildMenuManager, createChildActions, null);
		}
		if (createSiblingMenuManager != null) {
			populateManager(createSiblingMenuManager, createSiblingActions, null);
		}
		
		// append 'Show properties view' action
		menu.insertAfter(ICommonMenuConstants.GROUP_ADDITIONS, showPropertiesViewAction);
		
		updateGlobalActions(domain, (IStructuredSelection) selection);
		
		menu.add(undoAction);
	    menu.add(redoAction);
	    menu.add(deleteAction);
	}
	
	protected void updateGlobalActions(EditingDomain domain, IStructuredSelection selection) {
		// global actions
		deleteAction.setEditingDomain(domain);
		undoAction.setEditingDomain(domain);
		redoAction.setEditingDomain(domain);
		
		deleteAction.updateSelection((IStructuredSelection) selection);
		undoAction.update();
		redoAction.update();		
	}
	
	protected void shareGlobalActions(IActionBars actionBars) {
		actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), deleteAction);
		actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), undoAction);
	    actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), redoAction);		
	}
	
	protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
		Collection<IAction> actions = new ArrayList<IAction>();
		if (descriptors != null) {
			for (Object descriptor : descriptors) {
				actions.add(new CreateChildAction(activePart, selection, descriptor));
			}
		}
		return actions;
	}
	
	protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
		Collection<IAction> actions = new ArrayList<IAction>();
		if (descriptors != null) {
			for (Object descriptor : descriptors) {
				actions.add(new CreateSiblingAction(activePart, selection, descriptor));
			}
		}
		return actions;
	}
	
	protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
		if (actions != null) {
			for (IAction action : actions) {
				if (contributionID != null) {
					manager.insertBefore(contributionID, action);
				}
				else {
					manager.add(action);
				}
			}
		}
	}
	
	@Override
	public void dispose() {
		createChildMenuManager.dispose();
		createSiblingMenuManager.dispose();
		
		super.dispose();
	}
}
