/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.models;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.RepositoryException;

/**
 * Shadow model editor helper methods
 * 
 * @author Michal Malohlava
 *
 */
public class ShadowModelEditorUtils {
	
	/**
	 * Returns editing domain of default alternative for given project.
	 * 
	 * @return editing domain of default alternative or null
	 */
	public static EditingDomain getDefaultEditingDomain(IProject project) throws RepositoryException {
		
		return getDefaultShadowModelEditor(project).getEditingDomain();
	}
	
	/**
	 * Returns {@link ShadowModelEditor} associated with default alternative.
	 * 
	 * @param project
	 * @return 
	 * @throws RepositoryException
	 */
	public static ShadowModelEditor getDefaultShadowModelEditor(IProject project) throws RepositoryException {
		EditingDomain result = null;
		
		IQProject qProject = QImpressCore.getQProject(project);
		
		IQAlternative defAlternative = qProject.getRepository().getDefaultAlternative();
		
		ShadowModelEditor smEditor = (ShadowModelEditor) Platform.getAdapterManager().getAdapter(defAlternative, ShadowModelEditor.class);
		
		return smEditor;
	}
	
	/**
	 * 
	 * @param eo
	 * @return
	 */
	public static ShadowModelEditor getShadowModelEditor(EObject eo) {
		return ((ShadowModelEditorAdapter) EcoreUtil.getRegisteredAdapter(eo, ShadowModelEditor.class)).getShadowModelEditor();		
	}
}
