/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.models;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

/**
 * @author Michal Malohlava
 *
 */
public class ShadowModelEditorAdapterFactory extends AdapterFactoryImpl {
	
	private ShadowModelEditorAdapter shadowModelEditorAdapter = new ShadowModelEditorAdapter();
	
	public ShadowModelEditorAdapterFactory(ShadowModelEditor shadowModelEditor) {
		this.shadowModelEditorAdapter.setShadowModelEditor(shadowModelEditor);				
	}
	
	@Override
	protected Adapter createAdapter(Notifier target) {
		return this.shadowModelEditorAdapter;
	}
	
	@Override
	protected Object resolve(Object object, Object type) {
		if (type == ShadowModelEditor.class) {
			return this.shadowModelEditorAdapter.getShadowModelEditor();			
		} else {
			return super.resolve(object, type);
		}
	}
	
	@Override
	public boolean isFactoryForType(Object type) {		
		return type == ShadowModelEditor.class;
	}

}
