/**
 * 
 */
package eu.qimpress.ide.backbone.core.ui.models;

import org.eclipse.ui.IStartup;

import eu.qimpress.ide.backbone.core.ui.models.adapters.QModelsComposedAdapterFactoryProvider;

/**
 * This initializer try to initialize {@link QModelsComposedAdapterFactoryProvider} on the startup of eclipse.
 * 
 * The adapter factory is initialized to avoid annoying delay on the first click on model tree.
 *  
 * @author Michal Malohlava
 *
 */
public class AdapterFactoryInitializer implements IStartup {

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IStartup#earlyStartup()
	 */
	@Override
	public void earlyStartup() {
		QModelsComposedAdapterFactoryProvider.getInstance().initializeFactoryProvider();
	}

}
