package eu.qimpress.ide.project.repository.folders;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

import eu.qimpress.ide.project.Activator;
import eu.qimpress.ide.project.RepositoryAccess;

public class RepositoryFolder implements IWorkbenchAdapter {

	private Object parent;
	private RepositoryAccess repoAccess;
	
	public RepositoryFolder(RepositoryAccess repoAccess, Object parent) {		
		this.parent = parent;
		this.repoAccess = repoAccess;
	}
	
	@Override
	public Object[] getChildren(Object o) {
		
		return new Object[] {
				new ComponentsFolder(repoAccess, this),
				new InterfacesFolder(repoAccess, this),
				new TypesFolder(repoAccess, this),
				new MessageTypesFolder(repoAccess, this)				
			};
	}

	@Override
	public ImageDescriptor getImageDescriptor(Object object) {
		return Activator.getImageDescriptor("icons/repository-16.png");
	}

	@Override
	public String getLabel(Object o) {
		return "Repository";
	}

	@Override
	public Object getParent(Object o) {
		return parent;
	}


}
