package eu.qimpress.ide.project.repository.folders;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageDescriptor;

import eu.qimpress.ide.project.Activator;
import eu.qimpress.ide.project.RepositoryAccess;
import eu.qimpress.samm.staticstructure.MessageType;

/**
 * 
 * @author Michal Malohlava
 *
 */
public class MessageTypesFolder extends AbstractFolder {

	public MessageTypesFolder(RepositoryAccess repoAccess, RepositoryFolder parent) {
		super(repoAccess, parent);
	}

	@Override
	public Object[] getChildren(Object o) {
		EList<MessageType> messagetypes = this.repositoryAccess.getRepository().getMessagetype();
				
		return messagetypes.toArray();
	}

	@Override
	public ImageDescriptor getImageDescriptor(Object object) {		
		return Activator.getImageDescriptor("icons/components-folder-16.png");
	}

	@Override
	public String getLabel(Object o) {
		return "Message types";
	}

}
